/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import net.grelf.Util;
import net.grelf.image.Calibration;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8or16Base;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Metadata;
import net.grelf.image.Timer;

public class Image8
extends Image8or16Base
implements Image,
Cloneable,
Serializable {
    private static final int DEFAULT_COLOUR_IMAGE_TYPE = 5;
    private static final int DEFAULT_MONO_IMAGE_TYPE = 10;
    private static GraphicsConfiguration graphicsConfig = null;

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return graphicsConfig;
    }

    public Image8(int n, int n2, int n3) {
        this(n, n2, n3, false, false);
    }

    public Image8(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            Util.warning("Error", "Cannot create an image " + n + "x" + n2 + "x" + n3 + "x8");
            return;
        }
        this.bim = bl2 ? Image8.getGraphicsConfiguration().createCompatibleImage(n, n2) : (1 == n3 ? new BufferedImage(n, n2, 10) : new BufferedImage(n, n2, 5));
        this.setCalibration(new Calibration());
        this.setFilePath("New image");
        this.setMetadata(new Metadata());
        this.zeroPxInt = new int[n3];
        this.zeroPxDouble = new double[n3];
        for (int i = 0; i < n3; ++i) {
            this.zeroPxInt[i] = 0;
            this.zeroPxDouble[i] = 0.0;
        }
        if (null != this.bim && bl) {
            WritableRaster writableRaster = this.bim.getRaster();
            for (int i = 0; i < writableRaster.getHeight(); ++i) {
                for (int j = 0; j < writableRaster.getWidth(); ++j) {
                    writableRaster.setPixel(j, i, this.zeroPxInt);
                }
            }
        }
    }

    public Image8(BufferedImage bufferedImage) throws IncompatibleImageException {
        this(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getSampleModel().getNumBands());
        if (null != this.bim) {
            this.set(bufferedImage);
        }
    }

    @Override
    public void add(Image image) throws IncompatibleImageException {
        if (!(image instanceof Image8)) {
            throw new IncompatibleImageException("Cannot add " + image.getBitsPerChannel() + "-bit image into 8-bit one");
        }
        this.add(((Image8)image).getBufferedImage());
    }

    @Override
    public Image clone() {
        try {
            return new Image8(this.bim);
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.logWarning("Could not clone Image8");
            return null;
        }
    }

    @Override
    public Image8 convertToImage8() {
        return this;
    }

    @Override
    public Image16 convertToImage16() {
        Timer timer = new Timer("Image8.convertToImage16", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image16 image16 = new Image16(n, n2, n3);
        int[] nArray = new int[n3];
        double d = 257.0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n) {
                nArray = this.getPixel(n5, i);
                for (int j = 0; j < n3; ++j) {
                    nArray[j] = (int)((double)nArray[j] * d);
                }
                image16.setPixel(n5, i, nArray);
                ++n5;
                ++n4;
            }
        }
        image16.setCalibration(this.getCalibration());
        image16.setFilePath(this.getFilePath());
        this.getMetadata().removeTiffFields();
        image16.setMetadata(this.getMetadata());
        timer.stop();
        return image16;
    }

    @Override
    public Image32 convertToImage32() {
        return this.convertToImage16().convertToImage32();
    }

    @Override
    public Image64 convertToImage64() {
        return this.convertToImage32().convertToImage64();
    }

    @Override
    public Image gnomonicProjection(int n, double d, double d2) {
        try {
            return new Image8(this.gnomonicProjection(this.bim, n, d, d2));
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.logWarning(incompatibleImageException.toString());
            return null;
        }
    }

    @Override
    public Image inverseGnomonicProjection(int n, double d, double d2) {
        try {
            return new Image8(this.inverseGnomonicProjection(this.bim, n, d, d2));
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.logWarning(incompatibleImageException.toString());
            return null;
        }
    }

    @Override
    public boolean isRaw() {
        return false;
    }

    @Override
    public Image[] splitChannels() {
        Timer timer = new Timer("Image8.splitChannels", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image[] imageArray = new Image8[n3];
        for (int i = 0; i < n3; ++i) {
            imageArray[i] = new Image8(n, n2, 1);
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[1];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray = this.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray2[0] = nArray[k];
                    ((Image8or16Base)imageArray[k]).setPixel(j, i, nArray2);
                }
            }
        }
        timer.stop();
        return imageArray;
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        graphicsConfig = graphicsDevice.getDefaultConfiguration();
    }
}

