/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JComponent;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.FileIO_XMLFilter;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.image.Image;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8or16Base;
import net.grelf.image.RangeDouble;
import net.grelf.image.RangeInt;
import net.grelf.image.Timer;

public class HistogramAll
extends JComponent
implements Printable {
    protected int nLevels;
    protected int nBands;
    protected int[][] freq = null;
    protected int scale = 1;
    protected static final int MAX_NLEVELS = (int)StrictMath.pow(2.0, 24.0);
    protected int[][] fbin = null;
    protected String[] xLabels = null;

    protected HistogramAll() {
    }

    public HistogramAll(Image image) {
        this.buildData(image);
        Dimension dimension = new Dimension(340, 300);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    protected void buildData(Image image) {
        if (image instanceof Image8or16Base) {
            Image8or16Base image8or16Base = (Image8or16Base)image;
            BufferedImage bufferedImage = image8or16Base.getBufferedImage();
            this.nLevels = image8or16Base.getMaxLevel() + 1;
            this.xLabels = 8 == image8or16Base.getBitsPerChannel() ? new String[]{"0", "50", "100", "150", "200", "250"} : new String[]{"0", "13k", "26k", "38k", "51k", "64k"};
            this.nBands = image8or16Base.getNBands();
            this.freq = new int[this.nBands][this.nLevels + 1];
            this.fbin = new int[this.nBands][256];
            for (int i = 0; i < this.nLevels; ++i) {
                for (int j = 0; j < this.nBands; ++j) {
                    this.freq[j][i] = 0;
                }
            }
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[this.nBands];
            Point point = new Point(0, 0);
            Point point2 = new Point(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
            for (int i = point.y; i <= point2.y; ++i) {
                for (int j = point.x; j <= point2.x; ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    for (int k = 0; k < this.nBands; ++k) {
                        int[] nArray2 = this.freq[k];
                        int n = nArray[k];
                        nArray2[n] = nArray2[n] + 1;
                    }
                }
            }
            this.reBin();
        } else if (image instanceof Image32) {
            Image32 image32 = (Image32)image;
            RangeInt rangeInt = image32.getRangeByRescanning();
            this.nLevels = rangeInt.high + 1;
            if (this.nLevels > MAX_NLEVELS) {
                this.scale = this.nLevels / MAX_NLEVELS + 1;
                this.nLevels /= this.scale;
            }
            this.xLabels = new String[6];
            int n = rangeInt.high / 5;
            int n2 = 0;
            int n3 = 0;
            while (n2 < 6) {
                this.xLabels[n2] = "" + n3 / 1000 + "k";
                ++n2;
                n3 += n;
            }
            this.nBands = image32.getNBands();
            this.freq = new int[this.nBands][this.nLevels + 1];
            this.fbin = new int[this.nBands][256];
            for (n2 = 0; n2 < this.nLevels + 1; ++n2) {
                for (n3 = 0; n3 < this.nBands; ++n3) {
                    this.freq[n3][n2] = 0;
                }
            }
            int[] nArray = new int[this.nBands];
            Point point = new Point(0, 0);
            Point point3 = new Point(image32.getWidth() - 1, image32.getHeight() - 1);
            for (int i = point.y; i <= point3.y; ++i) {
                for (int j = point.x; j <= point3.x; ++j) {
                    nArray = image32.getPixel(j, i);
                    for (int k = 0; k < this.nBands; ++k) {
                        int[] nArray3 = this.freq[k];
                        int n4 = nArray[k] / this.scale;
                        nArray3[n4] = nArray3[n4] + 1;
                    }
                }
            }
            this.reBin();
        } else if (image instanceof Image64) {
            Image64 image64 = (Image64)image;
            RangeDouble rangeDouble = image64.getRangeDouble();
            if (rangeDouble.low < 0.0) {
                image64.add(-rangeDouble.low);
                rangeDouble.high -= rangeDouble.low;
                rangeDouble.low = 0.0;
            }
            if (rangeDouble.high + 1.0 > (double)MAX_NLEVELS) {
                this.scale = 1 + (int)((rangeDouble.high + 1.0) / (double)MAX_NLEVELS);
                this.nLevels = (int)((rangeDouble.high + 1.0) / (double)this.scale);
            } else {
                this.nLevels = (int)rangeDouble.high + 1;
            }
            this.xLabels = new String[6];
            int n = (int)((rangeDouble.high - rangeDouble.low) / 5.0);
            int n5 = 0;
            int n6 = (int)rangeDouble.low;
            while (n5 < 6) {
                this.xLabels[n5] = "" + n6 / 1000 + "k";
                ++n5;
                n6 += n;
            }
            this.nBands = image64.getNBands();
            this.freq = new int[this.nBands][this.nLevels + 1];
            this.fbin = new int[this.nBands][256];
            n5 = 0;
            for (n6 = 0; n6 < this.nLevels + 1; ++n6) {
                for (int i = 0; i < this.nBands; ++i) {
                    this.freq[i][n6] = 0;
                }
            }
            double[] dArray = new double[this.nBands];
            Point point = new Point(0, 0);
            Point point4 = new Point(image64.getWidth() - 1, image64.getHeight() - 1);
            for (int i = point.y; i <= point4.y; ++i) {
                for (int j = point.x; j <= point4.x; ++j) {
                    dArray = image64.getPixelDouble(j, i);
                    for (int k = 0; k < this.nBands; ++k) {
                        int n7 = (int)(dArray[k] / (double)this.scale);
                        if (n7 >= 0 && n7 <= this.nLevels) {
                            int[] nArray = this.freq[k];
                            int n8 = n7;
                            nArray[n8] = nArray[n8] + 1;
                            continue;
                        }
                        n5 = 1;
                    }
                }
            }
            if (n5 != 0) {
                Util.logWarning("Histogram freq index went out of range");
            }
            this.reBin();
        }
    }

    protected void reBin() {
        if (256 == this.nLevels) {
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < this.nBands; ++j) {
                    this.fbin[j][i] = this.freq[j][i];
                }
            }
        } else {
            int n = this.nLevels / 256;
            int n2 = 0;
            for (int i = 0; n2 < this.nLevels && i < 256; n2 += n, ++i) {
                int n3;
                for (n3 = 0; n3 < this.nBands; ++n3) {
                    this.fbin[n3][i] = 0;
                }
                for (n3 = n2; n3 < n2 + n; ++n3) {
                    for (int j = 0; j < this.nBands; ++j) {
                        int[] nArray = this.fbin[j];
                        int n4 = i;
                        nArray[n4] = nArray[n4] + this.freq[j][n3] * this.scale;
                    }
                }
            }
        }
    }

    public void equalise(Image image) {
        int n;
        int n2;
        Timer timer = new Timer("HistogramAll.equalise", image);
        int[][] nArray = new int[this.nBands][this.nLevels + 1];
        for (n2 = 0; n2 < this.nBands; ++n2) {
            nArray[n2][0] = this.freq[n2][0];
            for (n = 1; n <= this.nLevels; ++n) {
                nArray[n2][n] = nArray[n2][n - 1] + this.freq[n2][n];
            }
        }
        n2 = image.getWidth();
        n = image.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int[] nArray2 = image.getPixel(j, i);
                for (int k = 0; k < this.nBands; ++k) {
                    nArray2[k] = nArray[k][nArray2[k]];
                }
                image.setPixel(j, i, nArray2);
            }
        }
        image.getRangeByRescanning();
        timer.stop();
    }

    public int[] getMaxValues() {
        int[] nArray = new int[this.nBands];
        for (int i = 0; i < this.nBands; ++i) {
            int n;
            for (n = this.nLevels - 1; n >= 0 && this.freq[i][n] == 0; --n) {
            }
            nArray[i] = n;
        }
        return nArray;
    }

    public int[] getMinValues() {
        int[] nArray = new int[this.nBands];
        for (int i = 0; i < this.nBands; ++i) {
            int n;
            for (n = 0; n < this.nLevels && this.freq[i][n] == 0; ++n) {
            }
            nArray[i] = n;
        }
        return nArray;
    }

    public int[] getModes() {
        return this.getModes(0, this.nLevels - 1);
    }

    public int[] getModes(int n, int n2) {
        int n3;
        int[] nArray = new int[this.nBands];
        int[] nArray2 = new int[this.nBands];
        for (n3 = 0; n3 < this.nBands; ++n3) {
            nArray[n3] = 0;
            nArray2[n3] = 0;
        }
        for (n3 = n; n3 <= n2; ++n3) {
            for (int i = 0; i < this.nBands; ++i) {
                if (this.freq[i][n3] <= nArray[i]) continue;
                nArray[i] = this.freq[i][n3];
                nArray2[i] = n3;
            }
        }
        return nArray2;
    }

    public Statistics[] getStatistics(int n, int n2) {
        Statistics[] statisticsArray = new Statistics[this.nBands];
        for (int i = 0; i < this.nBands; ++i) {
            statisticsArray[i] = new Statistics(this.freq[i], n, n2, this.scale);
        }
        return statisticsArray;
    }

    public Statistics[] getStatistics() {
        return this.getStatistics(0, this.freq[0].length - 1);
    }

    private void drawLineRGB(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        if (n5 > n4) {
            if (n4 > n3) {
                if (n3 > 0) {
                    graphics2D.setPaint(Color.white);
                    graphics2D.drawLine(n, n2, n, n2 - n3);
                }
                if (n4 > n3) {
                    graphics2D.setPaint(Color.cyan);
                    graphics2D.drawLine(n, n2 - n3 - 1, n, n2 - n4);
                }
                if (n5 > n4) {
                    graphics2D.setPaint(Color.blue);
                    graphics2D.drawLine(n, n2 - n4 - 1, n, n2 - n5);
                }
            } else if (n5 > n3) {
                if (n4 > 0) {
                    graphics2D.setPaint(Color.white);
                    graphics2D.drawLine(n, n2, n, n2 - n4);
                }
                if (n3 > n4) {
                    graphics2D.setPaint(Color.magenta);
                    graphics2D.drawLine(n, n2 - n4 - 1, n, n2 - n3);
                }
                if (n5 > n3) {
                    graphics2D.setPaint(Color.blue);
                    graphics2D.drawLine(n, n2 - n3 - 1, n, n2 - n5);
                }
            } else {
                if (n4 > 0) {
                    graphics2D.setPaint(Color.white);
                    graphics2D.drawLine(n, n2, n, n2 - n4);
                }
                if (n5 > n4) {
                    graphics2D.setPaint(Color.magenta);
                    graphics2D.drawLine(n, n2 - n4 - 1, n, n2 - n5);
                }
                if (n3 > n5) {
                    graphics2D.setPaint(Color.red);
                    graphics2D.drawLine(n, n2 - n5 - 1, n, n2 - n3);
                }
            }
        } else if (n5 > n3) {
            if (n3 > 0) {
                graphics2D.setPaint(Color.white);
                graphics2D.drawLine(n, n2, n, n2 - n3);
            }
            if (n5 > n3) {
                graphics2D.setPaint(Color.cyan);
                graphics2D.drawLine(n, n2 - n3 - 1, n, n2 - n5);
            }
            if (n4 > n5) {
                graphics2D.setPaint(Color.green);
                graphics2D.drawLine(n, n2 - n5 - 1, n, n2 - n4);
            }
        } else if (n4 > n3) {
            if (n5 > 0) {
                graphics2D.setPaint(Color.white);
                graphics2D.drawLine(n, n2, n, n2 - n5);
            }
            if (n3 > n5) {
                graphics2D.setPaint(Color.yellow);
                graphics2D.drawLine(n, n2 - n5 - 1, n, n2 - n3);
            }
            if (n4 > n3) {
                graphics2D.setPaint(Color.green);
                graphics2D.drawLine(n, n2 - n3 - 1, n, n2 - n4);
            }
        } else {
            if (n5 > 0) {
                graphics2D.setPaint(Color.white);
                graphics2D.drawLine(n, n2, n, n2 - n5);
            }
            if (n4 > n5) {
                graphics2D.setPaint(Color.yellow);
                graphics2D.drawLine(n, n2 - n5 - 1, n, n2 - n4);
            }
            if (n3 > n4) {
                graphics2D.setPaint(Color.red);
                graphics2D.drawLine(n, n2 - n4 - 1, n, n2 - n3);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4;
        int n5 = n + 48;
        int n6 = n2 + 278;
        graphics2D.setPaint(new Color(212, 208, 200));
        graphics2D.fillRect(n, n2, this.getWidth(), this.getHeight());
        graphics2D.setPaint(Color.black);
        int n7 = 0;
        for (n4 = 0; n4 < 256; n4 += 50) {
            n3 = n5 + n4;
            graphics2D.drawLine(n3, n6 - 256, n3, n6 + 5);
            if (null != this.xLabels) {
                graphics2D.drawString(this.xLabels[n7], n3 - 5, n6 + 20);
            }
            ++n7;
        }
        graphics2D.drawString("level", n5 + 200, n6 + 40);
        String[] stringArray = new String[]{"   0", "   1", "  10", " 100", "  1k", " 10k", "100k", "  1M", " 10M", " 100M"};
        n4 = 0;
        n3 = 0;
        while (n4 < 10) {
            int n8 = n6 - n3;
            graphics2D.drawLine(n5 - 5, n8, n5 + 256, n8);
            graphics2D.drawString(stringArray[n4], n5 - 35, n8);
            ++n4;
            n3 += 25;
        }
        graphics2D.drawString("freq.", n5 - 45, n6 - 260);
        if (this.nBands == 1) {
            graphics2D.setPaint(Color.black);
            n4 = 0;
            n3 = n5;
            while (n4 < 256) {
                graphics2D.drawLine(n3, n6, n3, n6 - this.yLog(this.fbin[0][n4]));
                ++n4;
                ++n3;
            }
        } else if (this.nBands == 2) {
            n4 = 0;
            n3 = n5;
            while (n4 < 256) {
                this.drawLineRGB(graphics2D, n3, n6, this.yLog(this.fbin[0][n4]), this.yLog(this.fbin[1][n4]), this.yLog(0));
                ++n4;
                ++n3;
            }
        } else {
            n4 = 0;
            n3 = n5;
            while (n4 < 256) {
                this.drawLineRGB(graphics2D, n3, n6, this.yLog(this.fbin[0][n4]), this.yLog(this.fbin[1][n4]), this.yLog(this.fbin[2][n4]));
                ++n4;
                ++n3;
            }
        }
    }

    private int yLog(int n) {
        if (1 > n) {
            return 0;
        }
        return (int)(25.0 * (1.0 + StrictMath.log10(n)) + 0.5);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics, 0, 0);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.draw(graphics2D, 0, 0);
        return 0;
    }

    public void saveCSV() {
        String string = FileIO.selectOutputFile("Create CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "x.csv");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                if (this.nBands == 3) {
                    printWriter.println("level,freq R,freq G,freq B");
                    for (int i = 0; i < this.freq[0].length; ++i) {
                        printWriter.println(i + "," + this.freq[0][i] + "," + this.freq[1][i] + "," + this.freq[2][i] + ",");
                    }
                } else if (this.nBands == 1) {
                    printWriter.println("level,frequency");
                    for (int i = 0; i < this.freq[0].length; ++i) {
                        printWriter.println(i + "," + this.freq[0][i] + ",");
                    }
                } else {
                    int n;
                    printWriter.print("level");
                    for (n = 0; n < this.nBands; ++n) {
                        printWriter.print(",band " + n);
                    }
                    printWriter.println();
                    for (n = 0; n < this.freq[0].length; ++n) {
                        printWriter.print(n + ",");
                        for (int i = 0; i < this.nBands; ++i) {
                            printWriter.print(this.freq[i][n] + ",");
                        }
                        printWriter.println();
                    }
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning(this, "Error", (Object)iOException.toString());
            }
        }
    }

    public void saveXML() {
        String string = FileIO.selectOutputFile("Create XML file", null, new FileIO_XMLFilter[]{new FileIO_XMLFilter(1)}, "x.xml");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println("<?xml version=\"1.0\"?>");
                printWriter.println("<Histogram>");
                if (this.nBands == 3) {
                    for (int i = 0; i < this.freq[0].length; ++i) {
                        printWriter.println("\t<Entry><I>" + i + "</I><FreqR>" + this.freq[0][i] + "</FreqR><FreqG>" + this.freq[1][i] + "</FreqG><FreqB>" + this.freq[2][i] + "</FreqB></Entry>");
                    }
                } else if (this.nBands == 1) {
                    for (int i = 0; i < this.freq[0].length; ++i) {
                        printWriter.println("\t<Entry><I>" + i + "</I><Freq>" + this.freq[0][i] + "</Freq></Entry>");
                    }
                } else {
                    for (int i = 0; i < this.freq[0].length; ++i) {
                        printWriter.println("\t<Entry>");
                        printWriter.println("<I>" + i + "</I>");
                        for (int j = 0; j < this.nBands; ++j) {
                            printWriter.println("<FreqBand" + j + ">" + this.freq[j][i] + "</FreqBand" + j + ">");
                        }
                        printWriter.println("</Entry>");
                    }
                }
                printWriter.println("</Histogram>");
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning(this, "Error", (Object)iOException.toString());
            }
        }
    }
}

