/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import net.grelf.Util;
import net.grelf.image.FITS;

public class FITS_KeywordRecord {
    private String record;
    private String keyword;
    private String value;
    private String comment;

    public String getRecord() {
        return this.record;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return null != this.value;
    }

    public void setValue(String string) {
        this.record = FITS.padTo(80, this.keyword + "= " + string);
        this.value = string;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean hasComment() {
        return null != this.comment;
    }

    public FITS_KeywordRecord(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        this.record = stringBuffer.toString();
        if (80 != this.record.length()) {
            Util.warning("Error", "Fits record invalid length: " + this.record.length() + "\n" + this.record);
        }
        this.keyword = this.record.substring(0, 8).trim();
        int n = this.record.indexOf("/");
        this.comment = -1 < n ? this.record.substring(n + 1).trim() : null;
        if (this.record.charAt(8) == '=') {
            this.value = -1 < n ? this.record.substring(10, n).trim() : this.record.substring(10).trim();
            if (this.value.length() == 0) {
                this.value = null;
            }
        }
    }

    public FITS_KeywordRecord(String string, String string2) {
        if (8 < string.length()) {
            string = string.substring(0, 8);
        } else if (8 > string.length()) {
            string = FITS.padTo(8, string);
        }
        this.record = FITS.padTo(80, string + "= " + string2);
        this.keyword = string;
        this.value = string2;
        this.comment = null;
    }
}

