/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;
import net.grelf.image.Timer;

public class UnsharpMaskDialogue
extends AbstractDialogue
implements ChangeListener,
ActionListener,
ImPreviewActor {
    private static final int PREVIEW_WIDTH = 200;
    private static final int PREVIEW_HEIGHT = 200;
    private JLabel noteLabel = new JLabel("Yes, this dialogue needs more work");
    private JLabel radiusLabel = new JLabel("Gaussian blur radius");
    private JSlider radiusSlider;
    private JPanel radiusPanel = new JPanel();
    private JLabel proportionLabel = new JLabel("Subtraction strength");
    private JSlider proportionSlider;
    private JPanel proportionPanel = new JPanel();
    private JPanel sliderPanel = new JPanel();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private Image imOriginal;
    private int proportion = 50;
    private int radius = 10;
    private boolean accepted = false;

    public int getProportion() {
        return this.proportion;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public UnsharpMaskDialogue(ImFrame imFrame) {
        super((Frame)imFrame, "Unsharp mask");
        this.imOriginal = imFrame.getImPane().getImage();
        this.imPreview = new ImPreview(this.imOriginal, this, 200, 200);
        this.getContentPane().add((Component)this.imPreview, "North");
        this.proportion = 50;
        this.proportionSlider = new JSlider(0, 0, 100, this.proportion);
        this.proportionSlider.addChangeListener(this);
        this.proportionSlider.setMajorTickSpacing(20);
        this.proportionSlider.setMinorTickSpacing(5);
        this.proportionSlider.setPaintTicks(true);
        this.proportionSlider.setPaintLabels(true);
        this.proportionSlider.setValue(this.proportion);
        this.proportionPanel.add((Component)this.proportionLabel, "North");
        this.proportionPanel.add((Component)this.proportionSlider, "South");
        this.sliderPanel.add((Component)this.proportionPanel, "North");
        this.radius = 10;
        this.radiusSlider = new JSlider(0, 0, 100, this.radius);
        this.radiusSlider.addChangeListener(this);
        this.radiusSlider.setMajorTickSpacing(20);
        this.radiusSlider.setMinorTickSpacing(5);
        this.radiusSlider.setPaintTicks(true);
        this.radiusSlider.setPaintLabels(true);
        this.radiusSlider.setValue(this.proportion);
        this.radiusPanel.add((Component)this.radiusLabel, "North");
        this.radiusPanel.add((Component)this.radiusSlider, "South");
        this.sliderPanel.add((Component)this.radiusPanel, "South");
        this.getContentPane().add((Component)this.sliderPanel, "Center");
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "West");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "Center");
        this.buttonPanel.add((Component)this.noteLabel, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
    }

    public static void unsharpMask(Image image, Image image2, Point point, int n, int n2, int n3, int n4) {
        Util.notYet();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.proportionSlider) {
            this.proportion = ((JSlider)object).getValue();
            this.imPreview.refresh();
        } else if (object == this.radiusSlider) {
            this.radius = ((JSlider)object).getValue();
            this.imPreview.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.accepted = true;
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public static int perform(ImFrame imFrame) {
        Image image = imFrame.getImPane().getImage();
        UnsharpMaskDialogue unsharpMaskDialogue = new UnsharpMaskDialogue(imFrame);
        boolean bl = unsharpMaskDialogue.isAccepted();
        if (bl) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            int n = unsharpMaskDialogue.getRadius();
            int n2 = unsharpMaskDialogue.getProportion();
            String string = "Unsharp mask [radius " + n + ", proportion " + n2 + ":" + (100 - n2) + "]";
            imFrame.addHistory(string);
            Timer timer = new Timer(string, image);
            unsharpMaskDialogue.applyUnsharpMask(image);
            timer.stop();
            imFrame.redisplay();
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
        unsharpMaskDialogue.setVisible(false);
        unsharpMaskDialogue.dispose();
        if (bl) {
            return 1;
        }
        return -1;
    }

    private void applyUnsharpMask(Image image) {
        Util.notYet();
    }
}

