/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.grip.Config;
import net.grelf.grip.Defect;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image8or16Base;

public class Raw {
    private Raw() {
    }

    public static List<Defect> detectDefectivePixels(ImFrame imFrame) {
        List<Defect> list = null;
        Image image = imFrame.getImPane().getImage();
        if (image instanceof Image8or16Base && Util.confirm(imFrame, "Confirm", "Is this a dark frame, taken with the lens covered?")) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            list = Raw.detectDefectivePixels(((Image8or16Base)image).getBufferedImage());
            Raw.saveDefectsAsCSV(list);
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
        return list;
    }

    public static List<Defect> detectDefectivePixels(BufferedImage bufferedImage) {
        int n;
        Timer timer = new Timer("Raw.detectDefectivePixels", bufferedImage);
        ArrayList<Defect> arrayList = new ArrayList<Defect>();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = Image8or16Base.getNBands(bufferedImage);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = Integer.parseInt(Config.getValue("RawBits.value"));
        int n4 = 4095;
        double d = Double.parseDouble(Config.getValue("RawDefectLevel.value"));
        switch (n3) {
            case 8: {
                n4 = 255;
                break;
            }
            case 9: {
                n4 = 511;
                break;
            }
            case 10: {
                n4 = 1023;
                break;
            }
            case 11: {
                n4 = 2047;
                break;
            }
            case 12: {
                n4 = 4095;
                break;
            }
            case 13: {
                n4 = 8191;
                break;
            }
            case 14: {
                n4 = 16383;
                break;
            }
            case 15: {
                n4 = Short.MAX_VALUE;
                break;
            }
            case 16: {
                n4 = 65535;
            }
        }
        for (n = 0; n < n2; ++n) {
            nArray2[n] = (int)Math.round((double)n4 * d);
        }
        for (n = 0; n < bufferedImage.getHeight(); ++n) {
            for (int i = 0; i < bufferedImage.getWidth(); ++i) {
                writableRaster.getPixel(i, n, nArray);
                for (int j = 0; j < n2; ++j) {
                    if (nArray[j] <= nArray2[j]) continue;
                    arrayList.add(new Defect(new Point(i, n), nArray));
                }
            }
        }
        timer.stop();
        return arrayList;
    }

    public static void interpret(ImFrame imFrame) {
        Image image = imFrame.getImPane().getImage();
        if (image instanceof Image16) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Raw.interpret(image);
            imFrame.redisplay();
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    public static void interpret(Image image) {
        if (!(image instanceof Image16)) {
            Util.warning("Sorry", "Only 16-bit images may be interpreted as RAW (from DSLR)");
            return;
        }
        BufferedImage bufferedImage = ((Image16)image).getBufferedImage();
        Timer timer = new Timer("Raw.interpret", bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getWidth();
        int n2 = n - 1;
        int n3 = n - 2;
        int n4 = writableRaster.getHeight();
        int n5 = n4 - 1;
        int n6 = n4 - 2;
        int n7 = Image8or16Base.getNBands(bufferedImage);
        if (3 != n7) {
            Util.warning("Sorry", "Not 3 bands - cannot interpret as RAW");
        } else {
            int n8;
            int n9;
            int n10;
            Object object;
            int n11;
            int[] nArray = new int[n7];
            if (null != Config.defects) {
                int[] nArray2 = new int[n7];
                for (Defect defect : Config.defects) {
                    int n12;
                    n11 = 0;
                    object = defect.point;
                    Util.logInfo("Applied defect at ({0}, {1})", object.x, object.y);
                    for (n12 = 0; n12 < n7; ++n12) {
                        nArray2[n12] = 0;
                    }
                    if (object.x > 2) {
                        writableRaster.getPixel(object.x - 2, object.y, nArray);
                        for (n12 = 0; n12 < n7; ++n12) {
                            int n13 = n12;
                            nArray2[n13] = nArray2[n13] + nArray[n12];
                        }
                        ++n11;
                    }
                    if (object.x < n3) {
                        writableRaster.getPixel(object.x + 2, object.y, nArray);
                        for (n12 = 0; n12 < n7; ++n12) {
                            int n14 = n12;
                            nArray2[n14] = nArray2[n14] + nArray[n12];
                        }
                        ++n11;
                    }
                    if (object.y > 2) {
                        writableRaster.getPixel(object.x, object.y - 2, nArray);
                        for (n12 = 0; n12 < n7; ++n12) {
                            int n15 = n12;
                            nArray2[n15] = nArray2[n15] + nArray[n12];
                        }
                        ++n11;
                    }
                    if (object.y < n6) {
                        writableRaster.getPixel(object.x, object.y + 2, nArray);
                        for (n12 = 0; n12 < n7; ++n12) {
                            int n16 = n12;
                            nArray2[n16] = nArray2[n16] + nArray[n12];
                        }
                        ++n11;
                    }
                    for (n12 = 0; n12 < n7; ++n12) {
                        nArray[n12] = nArray2[n12] / n11;
                    }
                    writableRaster.setPixel(object.x, object.y, nArray);
                }
            }
            int n17 = 0;
            int n18 = 0;
            for (n10 = 0; n10 <= 1; ++n10) {
                for (n11 = 0; n11 <= 1; ++n11) {
                    writableRaster.getPixel(n11, n10, nArray);
                    if (nArray[0] > 0 && nArray[1] == 0 && nArray[2] == 0) {
                        n17 = n10;
                        continue;
                    }
                    if (nArray[0] != 0 || nArray[1] != 0 || nArray[2] <= 0) continue;
                    n18 = n10;
                }
            }
            n10 = 0;
            n11 = 65535;
            object = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            for (n9 = n17; n9 < n4; n9 += 2) {
                writableRaster.getSamples(0, n9, n, 1, 0, nArray3);
                if (nArray3[0] == 0) {
                    nArray3[0] = nArray3[1];
                }
                for (n8 = 1; n8 < n2; ++n8) {
                    if (nArray3[n8] == 0) {
                        nArray3[n8] = nArray3[n8 - 1] + nArray3[n8 + 1] >> 1;
                        continue;
                    }
                    if (nArray3[n8] > n10) {
                        n10 = nArray3[n8];
                        continue;
                    }
                    if (nArray3[n8] >= n11) continue;
                    n11 = nArray3[n8];
                }
                if (nArray3[n2] == 0) {
                    nArray3[n2] = nArray3[n3];
                }
                writableRaster.setSamples(0, n9, n, 1, 0, nArray3);
            }
            writableRaster.getSamples(0, n17, n, 1, 0, (int[])object);
            writableRaster.getSamples(0, n17 + 1, n, 1, 0, nArray3);
            for (n9 = n17 + 1; n9 < n5; n9 += 2) {
                writableRaster.getSamples(0, n9 + 1, n, 1, 0, nArray4);
                for (n8 = 0; n8 < n; ++n8) {
                    nArray3[n8] = object[n8] + nArray4[n8] >> 1;
                }
                writableRaster.setSamples(0, n9, n, 1, 0, nArray3);
                object = nArray3;
                nArray3 = nArray4;
                nArray4 = object;
            }
            writableRaster.getSamples(0, 0, n, 1, 1, (int[])object);
            writableRaster.getSamples(0, 1, n, 1, 1, nArray3);
            for (n9 = 1; n9 < n5; ++n9) {
                writableRaster.getSamples(0, n9 + 1, n, 1, 1, nArray4);
                for (n8 = 1; n8 < n2; ++n8) {
                    if (nArray3[n8] == 0) {
                        nArray3[n8] = object[n8] + nArray4[n8] + nArray3[n8 - 1] + nArray3[n8 + 1] >> 2;
                        continue;
                    }
                    if (nArray3[n8] > n10) {
                        n10 = nArray3[n8];
                        continue;
                    }
                    if (nArray3[n8] >= n11) continue;
                    n11 = nArray3[n8];
                }
                writableRaster.setSamples(0, n9, n, 1, 1, nArray3);
                object = nArray3;
                nArray3 = nArray4;
                nArray4 = object;
            }
            for (n9 = n18; n9 < n4; n9 += 2) {
                writableRaster.getSamples(0, n9, n, 1, 2, nArray3);
                if (nArray3[0] == 0) {
                    nArray3[0] = nArray3[1];
                }
                for (n8 = 1; n8 < n2; ++n8) {
                    if (nArray3[n8] == 0) {
                        nArray3[n8] = nArray3[n8 - 1] + nArray3[n8 + 1] >> 1;
                        continue;
                    }
                    if (nArray3[n8] > n10) {
                        n10 = nArray3[n8];
                        continue;
                    }
                    if (nArray3[n8] >= n11) continue;
                    n11 = nArray3[n8];
                }
                if (nArray3[n2] == 0) {
                    nArray3[n2] = nArray3[n3];
                }
                writableRaster.setSamples(0, n9, n, 1, 2, nArray3);
            }
            writableRaster.getSamples(0, n18, n, 1, 2, (int[])object);
            writableRaster.getSamples(0, n18 + 1, n, 1, 2, nArray3);
            for (n9 = n18 + 1; n9 < n5; n9 += 2) {
                writableRaster.getSamples(0, n9 + 1, n, 1, 2, nArray4);
                for (n8 = 0; n8 < n; ++n8) {
                    nArray3[n8] = object[n8] + nArray4[n8] >> 1;
                }
                writableRaster.setSamples(0, n9, n, 1, 2, nArray3);
                object = nArray3;
                nArray3 = nArray4;
                nArray4 = object;
            }
            n9 = 0;
            n8 = n10 - n11 + 1;
            if (n8 < 4096) {
                n9 = 4;
            } else if (n8 < 8192) {
                n9 = 3;
            } else if (n8 < 16384) {
                n9 = 2;
            } else if (n8 < 32768) {
                n9 = 1;
            }
            if (n9 > 0) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n; ++j) {
                        writableRaster.getPixel(j, i, nArray);
                        for (int k = 0; k < 3; ++k) {
                            int n19 = nArray[k] - n11;
                            nArray[k] = n19 > 0 ? n19 << n9 : 0;
                        }
                        writableRaster.setPixel(j, i, nArray);
                    }
                }
            }
            timer.stop();
        }
    }

    public static void removeMargin(ImFrame imFrame) {
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Raw.removeMargin(imFrame.getImPane().getImage());
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public static void removeMargin(Image image) {
        try {
            int n = image.getWidth();
            int n2 = image.getHeight();
            Point point = new Point(Integer.parseInt(Config.getValue("RawMarginLeft.value")), Integer.parseInt(Config.getValue("RawMarginTop.value")));
            Point point2 = new Point(n - Integer.parseInt(Config.getValue("RawMarginRight.value")) - 1, n2 - Integer.parseInt(Config.getValue("RawMarginBottom.value")) - 1);
            image.crop(point, point2);
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning("Error", "RAW margin not set as integer in configuration. Operation aborted.");
        }
    }

    private static void saveDefectsAsCSV(List<Defect> list) {
        String string = FileIO.selectOutputFile("Save as CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "x.csv");
        if (null != string) {
            try {
                PrintWriter printWriter = new PrintWriter(string);
                for (Defect defect : list) {
                    printWriter.print(defect.point.x + "," + defect.point.y);
                    for (int i = 0; i < defect.levels.length; ++i) {
                        printWriter.print("," + defect.levels[i]);
                    }
                    printWriter.println();
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning("Sorry", "Could not create\n{0}", string);
            }
        }
    }
}

