/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.grelf.Timer;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;

public class Pseudocolour {
    private int[][] lut;
    private int maxLevel;
    private static final int NBANDS = 3;

    public int[][] getLUT() {
        return this.lut;
    }

    public Pseudocolour(Image image) {
        int n;
        int n2;
        this.maxLevel = image.getRange().high;
        int n3 = this.maxLevel + 1;
        this.lut = new int[n3][3];
        int n4 = n3 / 8;
        int n5 = this.maxLevel / n4;
        int[] nArray = new int[3];
        for (n2 = 0; n2 < 3; ++n2) {
            nArray[n2] = 0;
        }
        n2 = 0;
        do {
            for (n = 0; n < 3; ++n) {
                this.lut[n2][n] = nArray[n];
            }
            nArray[0] = nArray[0] + n5;
        } while (++n2 <= n4);
        do {
            for (n = 0; n < 3; ++n) {
                this.lut[n2][n] = nArray[n];
            }
            nArray[1] = nArray[1] + n5;
        } while (++n2 <= n4 * 2);
        do {
            for (n = 0; n < 3; ++n) {
                this.lut[n2][n] = nArray[n];
            }
            nArray[0] = nArray[0] - n5;
        } while (++n2 <= n4 * 3);
        do {
            for (n = 0; n < 3; ++n) {
                this.lut[n2][n] = nArray[n];
            }
            nArray[2] = nArray[2] + n5;
        } while (++n2 <= n4 * 4);
        do {
            for (n = 0; n < 3; ++n) {
                this.lut[n2][n] = nArray[n];
            }
            nArray[1] = nArray[1] - n5;
        } while (++n2 <= n4 * 5);
        do {
            for (n = 0; n < 3; ++n) {
                this.lut[n2][n] = nArray[n];
            }
            nArray[0] = nArray[0] + n5;
        } while (++n2 <= n4 * 6);
        do {
            for (n = 0; n < 3; ++n) {
                this.lut[n2][n] = nArray[n];
            }
            nArray[1] = nArray[1] + n5;
        } while (++n2 <= n4 * 7);
        do {
            n = 0;
            while (n < 3) {
                this.lut[n2][n] = nArray[n];
                int n6 = n++;
                nArray[n6] = nArray[n6] - n5;
            }
        } while (++n2 < n3);
    }

    public void apply(ImFrame imFrame) {
        Image image = imFrame.getImPane().getImage();
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        this.apply(image);
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void apply(BufferedImage bufferedImage) {
        Timer timer = new Timer("Pseudocolour.apply", bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = Image8or16Base.getNBands(bufferedImage);
        int[] nArray = new int[n];
        n = Math.min(n, 3);
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                writableRaster.getPixel(j, i, nArray);
                for (int k = 0; k < n; ++k) {
                    nArray[k] = this.lut[nArray[k]][k];
                }
                writableRaster.setPixel(j, i, nArray);
            }
        }
        timer.stop();
    }

    public void apply(Image image) {
        net.grelf.image.Timer timer = new net.grelf.image.Timer("Pseudocolour.apply", image);
        int n = image.getNBands();
        n = Math.min(n, 3);
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int[] nArray = image.getPixel(j, i);
                for (int k = 0; k < n; ++k) {
                    nArray[k] = nArray[k] <= this.maxLevel ? this.lut[nArray[k]][k] : this.lut[this.maxLevel][k];
                }
                image.setPixel(j, i, nArray);
            }
        }
        image.getRangeByRescanning();
        timer.stop();
    }

    public void contour(int n) {
        for (int i = 0; i < this.lut.length; i += n) {
            for (int j = 0; j < 3; ++j) {
                this.lut[i][j] = 0;
            }
        }
    }

    public void invert() {
        for (int i = 0; i < this.lut.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.lut[i][j] = this.maxLevel = this.lut[i][j];
            }
        }
    }
}

