/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.grelf.Util;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.image.Image8or16Base;

public class Prof3D_Pane
extends ImPane {
    private static final int DIM = 256;
    private static final int GAP = 10;
    private static final int IMAGE_TYPE = 1;
    private BufferedImage image;
    private BufferedImage rIm;
    private BufferedImage gIm;
    private BufferedImage bIm;
    private int shift = 0;
    private int plotWd;
    private int plotHt;
    private static int[] line;

    public static void display(ImFrame imFrame) {
        Prof3D_Pane.display(imFrame, null, null);
    }

    public static void display(ImFrame imFrame, Point point, Point point2) {
        net.grelf.image.Image image = imFrame.getImPane().getImage();
        if (!(image instanceof Image8or16Base)) {
            Util.message("Sorry", "Not available for 32- or 64-bits-per-channel images");
        } else {
            BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
            if (Image8or16Base.getNBands(bufferedImage) != 3) {
                Util.message("Sorry", "3D profiles are only displayable for 3-channel (RGB) images.");
            } else {
                if (null == point) {
                    point = new Point(0, 0);
                }
                if (null == point2) {
                    point2 = new Point(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
                }
                ImFrame imFrame2 = new ImFrame("2D profile [" + imFrame.getCaption() + "]", new Prof3D_Pane(bufferedImage, point, point2));
            }
        }
    }

    public Prof3D_Pane(BufferedImage bufferedImage) {
        this(bufferedImage, new Point(0, 0), new Point(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1));
    }

    public Prof3D_Pane(BufferedImage bufferedImage, Point point, Point point2) {
        super(null, 1556, 768, new GlassPane(DrawingMode.UNDEFINED, null, null));
        this.image = bufferedImage;
        int n = Image8or16Base.getBitsPerChannel(this.image);
        this.shift = n - 8;
        int n2 = Math.min(point.x, point2.x);
        int n3 = Math.min(point.y, point2.y);
        int n4 = Math.abs(point.x - point2.x) + 1;
        int n5 = Math.abs(point.y - point2.y) + 1;
        int n6 = 256;
        this.plotWd = n4 + n5;
        this.plotHt = n4 + n5 + n6;
        this.rIm = new BufferedImage(this.plotWd, this.plotHt, 1);
        this.gIm = new BufferedImage(this.plotWd, this.plotHt, 1);
        this.bIm = new BufferedImage(this.plotWd, this.plotHt, 1);
        this.setPreferredSize(new Dimension(3 * this.plotWd + 20, this.plotHt));
        WritableRaster writableRaster = this.image.getRaster();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        WritableRaster writableRaster2 = this.rIm.getRaster();
        WritableRaster writableRaster3 = this.gIm.getRaster();
        WritableRaster writableRaster4 = this.bIm.getRaster();
        if (this.shift <= 0) {
            for (int i = n3; i < n3 + n5; ++i) {
                for (int j = n2 + n4 - 1; j >= n2; --j) {
                    int n7;
                    writableRaster.getPixel(j, i, nArray);
                    int n8 = j + i;
                    int n9 = n6 + n4 + i - j;
                    nArray2[2] = 0;
                    nArray2[1] = 0;
                    for (n7 = 0; n7 < nArray[0]; ++n7) {
                        nArray2[0] = line[n7];
                        writableRaster2.setPixel(n8, n9 - n7, nArray2);
                    }
                    nArray2[2] = 0;
                    nArray2[0] = 0;
                    for (n7 = 0; n7 < nArray[1]; ++n7) {
                        nArray2[1] = line[n7];
                        writableRaster3.setPixel(n8, n9 - n7, nArray2);
                    }
                    nArray2[1] = 0;
                    nArray2[0] = 0;
                    for (n7 = 0; n7 < nArray[2]; ++n7) {
                        nArray2[2] = line[n7];
                        writableRaster4.setPixel(n8, n9 - n7, nArray2);
                    }
                }
            }
        } else {
            for (int i = n3; i < n3 + n5; ++i) {
                for (int j = n2 + n4 - 1; j >= n2; --j) {
                    int n10;
                    writableRaster.getPixel(j, i, nArray);
                    int n11 = j + i;
                    int n12 = n6 + n4 + i - j;
                    nArray2[2] = 0;
                    nArray2[1] = 0;
                    for (n10 = 0; n10 < nArray[0] >> this.shift; ++n10) {
                        nArray2[0] = line[n10];
                        writableRaster2.setPixel(n11, n12 - n10, nArray2);
                    }
                    nArray2[2] = 0;
                    nArray2[0] = 0;
                    for (n10 = 0; n10 < nArray[1] >> this.shift; ++n10) {
                        nArray2[1] = line[n10];
                        writableRaster3.setPixel(n11, n12 - n10, nArray2);
                    }
                    nArray2[1] = 0;
                    nArray2[0] = 0;
                    for (n10 = 0; n10 < nArray[2] >> this.shift; ++n10) {
                        nArray2[2] = line[n10];
                        writableRaster4.setPixel(n11, n12 - n10, nArray2);
                    }
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.rIm, 0, 0, null);
        graphics2D.drawImage((Image)this.gIm, this.plotWd + 10, 0, null);
        graphics2D.drawImage((Image)this.bIm, 2 * (this.plotWd + 10), 0, null);
    }

    static {
        int n;
        line = new int[256];
        for (n = 0; n < 256; ++n) {
            Prof3D_Pane.line[n] = 255;
        }
        for (n = 10; n < 256; n += 10) {
            Prof3D_Pane.line[n + 1] = 0;
            Prof3D_Pane.line[n] = 0;
        }
    }
}

