/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.util.List;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.grelf.Util;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.Measurement;
import net.grelf.grip.MeasurementTableMenu;
import net.grelf.grip.MeasurementTableModel;
import net.grelf.grip.PointList;
import net.grelf.image.Calibration;

public class MeasurementTable {
    private JTable table;
    private MeasurementTableModel tableModel;

    protected JTable getJTable() {
        return this.table;
    }

    protected MeasurementTableModel getTableModel() {
        return this.tableModel;
    }

    public MeasurementTable(ImFrame imFrame) {
        Object object;
        String[][] stringArray;
        int n;
        List<ImFrame> list = GRIP.getImFramesList();
        int n2 = list.size();
        int n3 = 3 + n2;
        String[] stringArray2 = new String[n2];
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        for (n = 0; n < list.size(); ++n) {
            List<Measurement> list2;
            ImFrame imFrame2 = list.get(n);
            stringArray2[n] = imFrame2.getFilePath();
            stringArray = null;
            switch (imFrame2.getGP().getDrawingMode()) {
                case POINT: {
                    stringArray = "Point";
                    break;
                }
                case BLOB_PAIR: 
                case POINT_PAIR: {
                    stringArray = "Straight line";
                    break;
                }
                case RECTANGLE: {
                    stringArray = "Rectangle";
                    break;
                }
                case OPEN_CURVE: {
                    stringArray = "Curve";
                    break;
                }
                case CLOSED_CURVE: {
                    stringArray = "Area";
                    break;
                }
                case WHOLE: {
                    stringArray = "Whole image";
                    break;
                }
                default: {
                    stringArray = null;
                }
            }
            if (stringArray == null || (list2 = ((PointList)(object = imFrame2.getGP().getPoints())).getMeasurementList()) == null) continue;
            Calibration calibration = imFrame2.getImPane().getImage().getCalibration();
            for (int i = 0; i < list2.size(); ++i) {
                String[] stringArray3;
                Measurement measurement = list2.get(i);
                if ((!(measurement.value instanceof String) || ((String)measurement.value).length() <= 0) && !(measurement.value instanceof Integer) && !(measurement.value instanceof Long) && !(measurement.value instanceof Double)) continue;
                String string = (String)stringArray + "|" + measurement.name + "|" + measurement.units;
                if (!treeMap.containsKey(string)) {
                    stringArray3 = new String[n3 + 1];
                    stringArray3[0] = stringArray;
                    stringArray3[1] = measurement.name;
                    stringArray3[2] = null != measurement.units ? DefaultMeasurementHandler.powerPrefix(measurement.power) + measurement.units : (calibration.isCalibrated() ? DefaultMeasurementHandler.powerPrefix(measurement.power) + calibration.getUnits() : " pixels (uncalibrated)");
                    for (int j = 3; j < n3; ++j) {
                        stringArray3[j] = "";
                    }
                    if (measurement.value instanceof Integer) {
                        stringArray3[3 + n] = ((Integer)measurement.value).toString();
                    } else if (measurement.value instanceof Long) {
                        stringArray3[3 + n] = ((Long)measurement.value).toString();
                    } else if (measurement.value instanceof Double) {
                        double d = (Double)measurement.value;
                        stringArray3[3 + n] = Util.format(d);
                    } else if (measurement.value instanceof String) {
                        stringArray3[3 + n] = (String)measurement.value;
                    }
                    treeMap.put(string, stringArray3);
                    continue;
                }
                stringArray3 = (String[])treeMap.get(string);
                if (measurement.value instanceof Integer) {
                    stringArray3[3 + n] = ((Integer)measurement.value).toString();
                    continue;
                }
                if (measurement.value instanceof Long) {
                    stringArray3[3 + n] = ((Long)measurement.value).toString();
                    continue;
                }
                if (measurement.value instanceof Double) {
                    double d = (Double)measurement.value;
                    stringArray3[3 + n] = Util.format(d);
                    continue;
                }
                if (!(measurement.value instanceof String)) continue;
                stringArray3[3 + n] = (String)measurement.value;
            }
        }
        n = treeMap.size();
        if (n == 0) {
            Util.message("Sorry", "No measurements found for these images");
        } else {
            int n4;
            int n5 = 3 + n;
            stringArray = new String[n5][n3];
            object = treeMap.values().iterator();
            for (n4 = 0; n4 < 3; ++n4) {
                stringArray[n4][0] = "";
                stringArray[n4][1] = "";
                stringArray[n4][2] = "";
            }
            n4 = 3;
            int n6 = 0;
            while (n4 < n3) {
                String[] stringArray4 = Util.splitPath(stringArray2[n6]);
                int n7 = stringArray4.length - 1;
                for (int i = 2; n7 >= 0 && i >= 0; --n7, --i) {
                    stringArray[i][n4] = stringArray4[n7];
                }
                ++n4;
                ++n6;
            }
            stringArray[1][1] = "Directory";
            stringArray[0][1] = "Directory";
            stringArray[2][1] = "File name";
            n4 = 3;
            while (object.hasNext()) {
                String[] stringArray5 = (String[])object.next();
                for (int i = 0; i < n3; ++i) {
                    stringArray[n4][i] = stringArray5[i];
                }
                ++n4;
            }
            JFrame jFrame = new JFrame("Measurements in all open images");
            ImageIcon imageIcon = GRIP.getIcon();
            if (null != imageIcon) {
                jFrame.setIconImage(imageIcon.getImage());
            }
            this.tableModel = new MeasurementTableModel(stringArray);
            this.table = new JTable(this.tableModel);
            jFrame.getContentPane().add(new JScrollPane(this.table));
            jFrame.setDefaultCloseOperation(2);
            jFrame.setSize(700, 500);
            jFrame.setResizable(true);
            jFrame.setLocation(50, 50);
            new MeasurementTableMenu(jFrame, stringArray, this);
            jFrame.setVisible(true);
        }
    }
}

