/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.grelf.AbstractDialogue;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.grip.RangeSlider;
import net.grelf.grip.RangeSliderUser;
import net.grelf.image.Image;
import net.grelf.image.RangeInt;
import net.grelf.image.Threshold;

public class ImThreshRGBDialogue
extends AbstractDialogue
implements ActionListener,
ImPreviewActor,
RangeSliderUser {
    private Threshold thresh;
    private Image image;
    private int maxLevel;
    private RangeSlider sliderR;
    private RangeSlider sliderG;
    private RangeSlider sliderB;
    private JPanel sliderPanel = new JPanel();
    private JPanel andOrPanel = new JPanel();
    private ButtonGroup andOrGroup = new ButtonGroup();
    private JRadioButton andButton = new JRadioButton("AND", true);
    private JRadioButton orButton = new JRadioButton("OR", false);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private boolean accepted = false;

    public Threshold getThresh() {
        return this.thresh;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ImThreshRGBDialogue(ImFrame imFrame) {
        super((Frame)imFrame, "Adjust RGB threshold");
        int n;
        Image image = imFrame.getImPane().getImage();
        this.maxLevel = image.getRange().high;
        int n2 = image.getNBands();
        this.thresh = new Threshold(n2);
        for (n = 0; n < n2; ++n) {
            this.thresh.th[n].low = this.maxLevel / 2;
            this.thresh.th[n].high = this.maxLevel;
        }
        n = (int)((double)this.maxLevel / 20.0);
        int n3 = n * 2;
        RangeInt rangeInt = new RangeInt(0, this.maxLevel);
        this.sliderR = new RangeSlider(rangeInt, this.thresh.th[0], 0, Color.red, n3, n, "R", Color.black, 1, this);
        this.sliderG = new RangeSlider(rangeInt, this.thresh.th[1], 0, Color.green, n3, n, "G", Color.black, 1, this);
        this.sliderB = new RangeSlider(rangeInt, this.thresh.th[2], 0, Color.blue, n3, n, "B", Color.black, 1, this);
        this.sliderPanel.setLayout(new BorderLayout());
        this.sliderPanel.add((Component)this.sliderR, "North");
        this.sliderPanel.add((Component)this.sliderG, "Center");
        this.sliderPanel.add((Component)this.sliderB, "South");
        this.getContentPane().add((Component)this.sliderPanel, "Center");
        this.imPreview = new ImPreview(image, this);
        this.getContentPane().add((Component)this.imPreview, "North");
        this.buttonPanel.setLayout(new BorderLayout());
        this.andOrPanel.setLayout(new BorderLayout());
        this.andButton.addActionListener(this);
        this.andOrPanel.add((Component)this.andButton, "North");
        this.orButton.addActionListener(this);
        this.andOrPanel.add((Component)this.orButton, "South");
        this.andOrGroup.add(this.andButton);
        this.andOrGroup.add(this.orButton);
        this.buttonPanel.add((Component)this.andOrPanel, "West");
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "Center");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void rangeChanged(RangeSlider rangeSlider, RangeInt rangeInt) {
        if (rangeSlider == this.sliderR) {
            this.thresh.th[0].low = rangeInt.low;
            this.thresh.th[0].high = rangeInt.high;
        } else if (rangeSlider == this.sliderG) {
            this.thresh.th[1].low = rangeInt.low;
            this.thresh.th[1].high = rangeInt.high;
        } else if (rangeSlider == this.sliderB) {
            this.thresh.th[2].low = rangeInt.low;
            this.thresh.th[2].high = rangeInt.high;
        }
        this.imPreview.refresh();
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        double d = image2.getRangeDouble().high;
        double d2 = image.getRangeDouble().high;
        double d3 = d / d2;
        int n3 = image.getNBands();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[]{0, (int)d, 0};
        if (this.thresh.anding) {
            int n4 = point.y - n2 / 2;
            for (int i = 0; i < n2; ++i) {
                int n5 = point.x - n / 2;
                for (int j = 0; j < n; ++j) {
                    nArray = image.getPixel(n5, n4);
                    if (nArray[0] >= this.thresh.th[0].low && nArray[0] <= this.thresh.th[0].high && nArray[1] >= this.thresh.th[1].low && nArray[1] <= this.thresh.th[1].high && nArray[2] >= this.thresh.th[2].low && nArray[2] <= this.thresh.th[2].high) {
                        image2.setPixel(j, i, nArray2);
                    } else {
                        for (int k = 0; k < n3; ++k) {
                            nArray[k] = (int)((double)nArray[k] * d3);
                        }
                        image2.setPixel(j, i, nArray);
                    }
                    ++n5;
                }
                ++n4;
            }
        } else {
            int n6 = point.y - n2 / 2;
            for (int i = 0; i < n2; ++i) {
                int n7 = point.x - n / 2;
                for (int j = 0; j < n; ++j) {
                    nArray = image.getPixel(n7, n6);
                    if (nArray[0] >= this.thresh.th[0].low && nArray[0] <= this.thresh.th[0].high || nArray[1] >= this.thresh.th[1].low && nArray[1] <= this.thresh.th[1].high || nArray[2] >= this.thresh.th[2].low && nArray[2] <= this.thresh.th[2].high) {
                        image2.setPixel(j, i, nArray2);
                    } else {
                        for (int k = 0; k < n3; ++k) {
                            nArray[k] = (int)((double)nArray[k] * d3);
                        }
                        image2.setPixel(j, i, nArray);
                    }
                    ++n7;
                }
                ++n6;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.accepted = true;
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.accepted = false;
            this.setVisible(false);
        } else if (object == this.andButton && this.andButton.isSelected()) {
            this.thresh.anding = true;
            this.imPreview.refresh();
        } else if (object == this.orButton && this.orButton.isSelected()) {
            this.thresh.anding = false;
            this.imPreview.refresh();
        }
    }

    public static Threshold askThreshold(ImFrame imFrame) {
        Threshold threshold = new Threshold(imFrame.getImPane().getImage().getNBands());
        ImThreshRGBDialogue imThreshRGBDialogue = new ImThreshRGBDialogue(imFrame);
        threshold = imThreshRGBDialogue.isAccepted() ? imThreshRGBDialogue.getThresh() : null;
        imThreshRGBDialogue.setVisible(false);
        imThreshRGBDialogue.dispose();
        return threshold;
    }
}

