/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;
import net.grelf.image.Timer;

public class ImColourDialogue
extends AbstractDialogue
implements ChangeListener,
ActionListener,
ImPreviewActor {
    private Image image;
    private int maxLevel;
    private static final int MAX_PERCENT = 100;
    private int[] settings;
    private JSlider sliderR;
    private JSlider sliderG;
    private JSlider sliderB;
    private JLabel labelR = new JLabel();
    private JLabel labelG = new JLabel();
    private JLabel labelB = new JLabel();
    private JPanel sliderPanelR = new JPanel();
    private JPanel sliderPanelG = new JPanel();
    private JPanel sliderPanelB = new JPanel();
    private JPanel sliderPanel = new JPanel();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private Border border = BorderFactory.createLineBorder(Color.black, 1);
    private ImPreview imPreview;
    private boolean accepted = false;

    public int[] getSettings() {
        return this.settings;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    private String format(int n) {
        if (n < -10) {
            return " " + n + "% ";
        }
        if (n < 0) {
            return "  " + n + "% ";
        }
        if (n < 10) {
            return "  +" + n + "% ";
        }
        return " +" + n + "% ";
    }

    public ImColourDialogue(ImFrame imFrame) {
        super((Frame)imFrame, "Adjust colour balance");
        this.image = imFrame.getImPane().getImage();
        this.maxLevel = this.image.getRange().high;
        int n = this.image.getNBands();
        this.settings = new int[n];
        for (int i = 0; i < n; ++i) {
            this.settings[i] = 0;
        }
        this.sliderR = new JSlider(0, -100, 100, this.settings[0]);
        this.sliderR.setBackground(Color.red);
        this.sliderR.addChangeListener(this);
        this.sliderR.setMajorTickSpacing(10);
        this.sliderR.setMinorTickSpacing(5);
        this.sliderR.setPaintTicks(true);
        this.labelR.setText("R" + this.format(this.settings[0]));
        this.sliderPanelR.setBorder(this.border);
        this.sliderPanelR.setLayout(new BorderLayout());
        this.sliderPanelR.add((Component)this.labelR, "West");
        this.sliderPanelR.add((Component)this.sliderR, "Center");
        this.sliderG = new JSlider(0, -100, 100, this.settings[1]);
        this.sliderG.setBackground(Color.green);
        this.sliderG.addChangeListener(this);
        this.sliderG.setMajorTickSpacing(10);
        this.sliderG.setMinorTickSpacing(5);
        this.sliderG.setPaintTicks(true);
        this.labelG.setText("G" + this.format(this.settings[1]));
        this.sliderPanelG.setBorder(this.border);
        this.sliderPanelG.setLayout(new BorderLayout());
        this.sliderPanelG.add((Component)this.labelG, "West");
        this.sliderPanelG.add((Component)this.sliderG, "Center");
        this.sliderB = new JSlider(0, -100, 100, this.settings[2]);
        this.sliderB.setBackground(Color.blue);
        this.sliderB.addChangeListener(this);
        this.sliderB.setMajorTickSpacing(10);
        this.sliderB.setMinorTickSpacing(5);
        this.sliderB.setPaintTicks(true);
        this.labelB.setText("B" + this.format(this.settings[2]));
        this.sliderPanelB.setBorder(this.border);
        this.sliderPanelB.setLayout(new BorderLayout());
        this.sliderPanelB.add((Component)this.labelB, "West");
        this.sliderPanelB.add((Component)this.sliderB, "Center");
        this.sliderPanel.setLayout(new BorderLayout());
        this.sliderPanel.add((Component)this.sliderPanelR, "North");
        this.sliderPanel.add((Component)this.sliderPanelG, "Center");
        this.sliderPanel.add((Component)this.sliderPanelB, "South");
        this.getContentPane().add((Component)this.sliderPanel, "Center");
        this.imPreview = new ImPreview(this.image, this);
        this.getContentPane().add((Component)this.imPreview, "North");
        this.buttonPanel.setLayout(new BorderLayout());
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "Center");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        int n3;
        int n4 = image.getNBands();
        int[] nArray = new int[n4];
        double d = image2.getRange().high;
        double d2 = image.getRange().high;
        double d3 = d / d2;
        int[][] nArray2 = new int[n4][this.maxLevel + 1];
        int n5 = 0;
        while ((double)n5 <= d2) {
            for (n3 = 0; n3 < n4; ++n3) {
                nArray2[n3][n5] = (int)Math.min(d, d3 * (double)n5 * (100.0 + (double)this.settings[n3]) / 100.0);
            }
            ++n5;
        }
        n5 = point.y - n2 / 2;
        for (n3 = 0; n3 < n2; ++n3) {
            int n6 = point.x - n / 2;
            for (int i = 0; i < n; ++i) {
                nArray = image.getPixel(n6, n5);
                for (int j = 0; j < n4; ++j) {
                    nArray[j] = nArray2[j][nArray[j]];
                }
                image2.setPixel(i, n3, nArray);
                ++n6;
            }
            ++n5;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.sliderR) {
            this.settings[0] = this.sliderR.getValue();
            this.labelR.setText("R" + this.format(this.settings[0]));
            this.imPreview.refresh();
        } else if (object == this.sliderG) {
            this.settings[1] = this.sliderG.getValue();
            this.labelG.setText("G" + this.format(this.settings[1]));
            this.imPreview.refresh();
        } else if (object == this.sliderB) {
            this.settings[2] = this.sliderB.getValue();
            this.labelB.setText("B" + this.format(this.settings[2]));
            this.imPreview.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.accepted = true;
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public void applySettings(Image image) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        Point point = new Point(n / 2, n2 / 2);
        this.previewAction(image, image, point, n, n2);
    }

    public static int[] askSettings(ImFrame imFrame) {
        int n = imFrame.getImPane().getImage().getNBands();
        int[] nArray = new int[n];
        if (1 == n) {
            Util.message("Information", "Colour balancing is not relevant for monochrome (1-channel) images");
            nArray[0] = 0;
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = 0;
            }
            ImColourDialogue imColourDialogue = new ImColourDialogue(imFrame);
            if (imColourDialogue.isAccepted()) {
                imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
                imFrame.addHistory("Colour balance");
                nArray = imColourDialogue.getSettings();
                Image image = imFrame.getImPane().getImage();
                Timer timer = new Timer("ColourBalance", image);
                imColourDialogue.applySettings(image);
                timer.stop();
                imFrame.redisplay();
                imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            }
            imColourDialogue.setVisible(false);
            imColourDialogue.dispose();
        }
        return nArray;
    }
}

