/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.Util;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImageSizeAction;
import net.grelf.grip.ImageSizeDialogue;
import net.grelf.grip.Raw;
import net.grelf.grip.WarpingGrid;

public class GeometryMenu
extends JMenu
implements ActionListener,
MenuListener,
ImageSizeAction {
    private ImFrame imframe;
    private JMenuItem itemRaw;

    public GeometryMenu(ImFrame imFrame) {
        super("Geometry");
        this.imframe = imFrame;
        this.setMnemonic('G');
        this.add(Util.menuItem(this, "Crop", "crop", 67, 0));
        this.add(Util.menuItem(this, "Auto-crop (remove black rim)", "autocrop", 65, 0));
        if (imFrame.getImPane().getImage().isRaw()) {
            this.itemRaw = Util.menuItem(this, "Remove RAW margin", "margin", 77, 0);
            this.add(this.itemRaw);
        }
        this.addSeparator();
        this.add(Util.menuItem(this, "Flip horizontally", "fliph", 72, 0));
        this.add(Util.menuItem(this, "Flip vertically", "flipv", 86, 0));
        this.add(Util.menuItem(this, "Scale", "scale", 83, 0));
        this.add(Util.menuItem(this, "Fit image in m x n", "fit", 70, 70));
        this.add(Util.menuItem(this, "Rotate", "rotate", 82, 0));
        this.add(Util.menuItem(this, "Translate", "translate", 84, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Inverse gnomonic (plane to sphere)", "gnomonic_inv", 73, 0));
        this.add(Util.menuItem(this, "Gnomonic projection (sphere to plane)", "gnomonic", 71, 0));
        this.add(Util.menuItem(this, "Make warping grid", "warpmake", 77, 0));
        this.add(Util.menuItem(this, "Apply warping grid", "warpuse", 87, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Help about this menu", "help", 0, 0));
    }

    @Override
    public void process(ImageSizeDialogue imageSizeDialogue) {
        int n = imageSizeDialogue.getWidth();
        int n2 = imageSizeDialogue.getHeight();
        imageSizeDialogue.dispose();
        if (0 < n && 0 < n2) {
            this.imframe.fit(n, n2);
            this.imframe.addHistory("Fit in " + n + " x " + n2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("autocrop")) {
            this.imframe.addHistory("Crop automatically");
            this.imframe.autoCrop();
        } else if (string.equals("crop")) {
            this.imframe.addHistory("Crop manually");
            this.imframe.pushCaption();
            this.imframe.getGP().setDrawingMode(DrawingMode.CROP);
            this.imframe.setTitle("Click to set rectangle corners (Ctrl for square)");
        } else if (string.equals("fit")) {
            int n = 1024;
            int n2 = 768;
            new ImageSizeDialogue(n, n2, "Scale to fit", this);
        } else if (string.equals("fliph")) {
            this.imframe.addHistory("Flip horizontally");
            this.imframe.flipHorizontal();
        } else if (string.equals("flipv")) {
            this.imframe.addHistory("Flip vertically");
            this.imframe.flipVertical();
        } else if (string.equals("gnomonic")) {
            this.imframe.addHistory("Gnomonic projection");
            this.imframe.gnomonicProjection();
        } else if (string.equals("gnomonic_inv")) {
            this.imframe.addHistory("Inverse gnomonic projection");
            this.imframe.inverseGnomonicProjection();
        } else if (string.equals("help")) {
            HelpMenu.help("pages/geom_menu.html");
        } else if (string.equals("margin")) {
            this.imframe.addHistory("Remove RAW margin");
            Raw.removeMargin(this.imframe);
            this.itemRaw.setEnabled(false);
        } else if (string.equals("rotate")) {
            this.imframe.addHistory("Rotate");
            this.imframe.rotate();
        } else if (string.equals("translate")) {
            this.imframe.addHistory("Translate");
            this.imframe.translate();
        } else if (string.equals("scale")) {
            this.imframe.addHistory("Scale");
            this.imframe.scale();
        } else if (string.equals("warpmake")) {
            if (null != WarpingGrid.make(this.imframe)) {
                this.imframe.addHistory("made warping grid");
            }
        } else if (string.equals("warpuse") && null != WarpingGrid.use(this.imframe)) {
            this.imframe.addHistory("used warping grid");
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }
}

