/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.grelf.Util;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.GlassPane;
import net.grelf.grip.Histogram;
import net.grelf.grip.HistogramBlobs;
import net.grelf.grip.ImFrame;
import net.grelf.grip.Measurement;
import net.grelf.grip.MeasurementHandler;
import net.grelf.grip.PointList;
import net.grelf.grip.Profile1D;
import net.grelf.image.Calibration;

public class DefaultMeasurementHandler
implements MeasurementHandler,
Printable {
    private static HashPrintRequestAttributeSet atts = new HashPrintRequestAttributeSet();
    private StringBuffer message;
    private Histogram hist = null;
    private Profile1D prof = null;
    private HistogramBlobs histBlobs = null;
    private static int LINE_HEIGHT = 14;

    public static HashPrintRequestAttributeSet getAtts() {
        return atts;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Font font = new Font("SansSerif", 10, 0);
        StringBuffer stringBuffer = new StringBuffer(this.message.substring("<html>".length()));
        int n2 = 0;
        int n3 = LINE_HEIGHT * 2;
        int n4 = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(" 'at' HH:mm 'on' dd/MM/yyyy");
        graphics2D.setFont(font);
        graphics2D.drawString("printed" + simpleDateFormat.format(gregorianCalendar.getTime()), n2, n3);
        n3 += LINE_HEIGHT * 2;
        do {
            if (-1 == (n4 = stringBuffer.indexOf("<br>"))) {
                n4 = stringBuffer.indexOf("</html>");
            }
            if (-1 == n4) continue;
            graphics2D.drawString(stringBuffer.substring(0, n4), n2, n3);
            n3 += LINE_HEIGHT;
            stringBuffer.delete(0, n4 + 4);
        } while (-1 != n4);
        if (this.hist != null) {
            this.hist.draw(graphics2D, n2, n3 - 40);
        }
        if (this.prof != null) {
            this.prof.draw(graphics2D, n2, n3);
        }
        if (this.histBlobs != null) {
            this.histBlobs.draw(graphics2D, n2, n3 - 40);
        }
        return 0;
    }

    @Override
    public void process(ImFrame imFrame, PointList pointList, List<Measurement> list) {
        String[] stringArray;
        int n;
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Calibration calibration = imFrame.getImPane().getImage().getCalibration();
        this.message = new StringBuffer("<html>");
        this.hist = null;
        this.prof = null;
        this.histBlobs = null;
        if (null != imFrame.getFilePath() && (n = (stringArray = Util.splitPath(imFrame.getFilePath())).length) >= 3) {
            this.message.append(" ");
            this.message.append(stringArray[n - 3]);
            this.message.append(" / ");
            this.message.append(stringArray[n - 2]);
            this.message.append(" / ");
            this.message.append(stringArray[n - 1]);
            this.message.append("<br>");
        }
        for (int i = 0; i < list.size(); ++i) {
            double d;
            Measurement measurement = list.get(i);
            if (!(measurement.value instanceof Histogram || measurement.value instanceof Profile1D || measurement.value instanceof HistogramBlobs)) {
                if (measurement.value instanceof String && ((String)measurement.value).length() == 0) {
                    this.message.append(" ");
                    this.message.append(measurement.name);
                } else {
                    this.message.append(" ");
                    this.message.append(measurement.name);
                    this.message.append(" = ");
                }
            }
            if (measurement.value instanceof String) {
                this.message.append(" ");
                this.message.append(measurement.value);
            } else if (measurement.value instanceof Integer) {
                if (calibration.isCalibrated() && null == measurement.units) {
                    d = ((Integer)measurement.value).doubleValue();
                    d = this.scaleCalib(d, calibration, measurement.power);
                    this.message.append(" ");
                    this.message.append(Util.formatHTML(d));
                } else {
                    this.message.append(" ");
                    this.message.append(measurement.value.toString());
                }
            } else if (measurement.value instanceof Long) {
                if (calibration.isCalibrated() && null == measurement.units) {
                    d = ((Long)measurement.value).doubleValue();
                    d = this.scaleCalib(d, calibration, measurement.power);
                    this.message.append(" ");
                    this.message.append(Util.formatHTML(d));
                } else {
                    this.message.append(" ");
                    this.message.append(measurement.value.toString());
                }
            } else if (measurement.value instanceof Double) {
                d = (Double)measurement.value;
                if (calibration.isCalibrated() && null == measurement.units) {
                    d = this.scaleCalib(d, calibration, measurement.power);
                }
                this.message.append(" ");
                this.message.append(Util.formatHTML(d));
            } else if (measurement.value instanceof Histogram) {
                this.hist = (Histogram)measurement.value;
            } else if (measurement.value instanceof Profile1D) {
                this.prof = (Profile1D)measurement.value;
            } else if (measurement.value instanceof HistogramBlobs) {
                this.histBlobs = (HistogramBlobs)measurement.value;
            } else {
                this.message.append(" UNKNOWN VALUE OBJECT");
            }
            if (null != measurement.units) {
                this.message.append(" ");
                this.message.append(DefaultMeasurementHandler.powerPrefix(measurement.power));
                this.message.append(measurement.units);
            } else if (calibration.isCalibrated()) {
                this.message.append(" ");
                this.message.append(DefaultMeasurementHandler.powerPrefix(measurement.power));
                this.message.append(calibration.getUnits().getToUnits().getSymbol());
            } else {
                this.message.append("  pixels (uncalibrated)");
            }
            if (measurement.value instanceof Histogram || measurement.value instanceof Profile1D || measurement.value instanceof HistogramBlobs) continue;
            this.message.append(" <br>");
        }
        this.message.append(" </html>");
        JPanel jPanel = new JPanel(new BorderLayout());
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.prof) {
            JScrollPane jScrollPane = new JScrollPane(this.prof);
            jScrollPane.setSize(700, 400);
            jScrollPane.setPreferredSize(new Dimension(700, 400));
            jPanel.add((Component)jScrollPane, "North");
            JLabel jLabel = new JLabel(this.message.toString());
            JScrollPane jScrollPane2 = new JScrollPane(jLabel);
            jScrollPane2.setSize(700, 200);
            jScrollPane2.setPreferredSize(new Dimension(700, 200));
            jPanel.add((Component)jScrollPane2, "South");
        } else if (null != this.hist) {
            jPanel.add((Component)this.hist, "West");
            jPanel.add((Component)new JLabel(this.message.toString()), "East");
        } else if (null != this.histBlobs) {
            jPanel.add((Component)this.histBlobs, "West");
            jPanel.add((Component)new JLabel(this.message.toString()), "East");
        } else {
            jPanel.add((Component)new JLabel(this.message.toString()), "Center");
        }
        boolean bl = false;
        boolean bl2 = false;
        double d = -1.0;
        GlassPane glassPane = imFrame.getGP();
        DrawingMode drawingMode = glassPane.getDrawingMode();
        if (null != this.prof || null != this.hist || null != this.histBlobs) {
            stringBuffer.append("Save as XML;");
            stringBuffer.append("Save as CSV;");
        } else if (drawingMode == DrawingMode.BLOB_PAIR && -1 != this.message.indexOf("Stars:<br>")) {
            stringBuffer.append("Overlay meridian;");
            bl = true;
        }
        stringBuffer.append("Print;Copy data;Close");
        Object[] objectArray = stringBuffer.toString().split(";");
        int n2 = objectArray.length - 1;
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        int n3 = -1;
        do {
            int n4;
            Object object;
            JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2, GRIP.getIcon(), objectArray, objectArray[n2]);
            JDialog jDialog = jOptionPane.createDialog(imFrame, "Measured");
            jDialog.setDefaultCloseOperation(2);
            jDialog.setVisible(true);
            Object object2 = jOptionPane.getValue();
            if (null == object2) {
                return;
            }
            if (object2 instanceof String) {
                object = (String)object2;
                for (n4 = 0; n4 <= n2; ++n4) {
                    if (!((String)objectArray[n4]).equals(object)) continue;
                    n3 = n4;
                }
            }
            if (n3 == n2 - 1) {
                object = Toolkit.getDefaultToolkit();
                Clipboard clipboard = ((Toolkit)object).getSystemClipboard();
                clipboard.setContents(new StringSelection(this.message.toString()), GRIP.getInstance());
                continue;
            }
            if (n3 == n2 - 2) {
                object = PrinterJob.getPrinterJob();
                ((PrinterJob)object).setPrintable(this);
                if (!((PrinterJob)object).printDialog(atts)) continue;
                try {
                    ((PrinterJob)object).print();
                }
                catch (PrinterException printerException) {
                    Util.warning(jPanel, "Error", (Object)printerException);
                }
                continue;
            }
            if (n3 == n2 - 3) {
                if (null != this.prof) {
                    this.prof.saveCSV();
                }
                if (null != this.hist) {
                    this.hist.saveCSV();
                }
                if (null != this.histBlobs) {
                    this.histBlobs.saveCSV();
                }
                if (!bl) continue;
                object = "meridian angle in image = ";
                n4 = this.message.indexOf((String)object) + ((String)object).length();
                int n5 = this.message.indexOf("degrees", n4);
                String string = this.message.substring(n4, n5).trim();
                try {
                    d = Double.parseDouble(string);
                    bl2 = true;
                    glassPane.overlayMeridian(d);
                    glassPane.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    Util.logWarning("{0} cannot be parsed as double", string);
                }
                continue;
            }
            if (n3 != n2 - 4) continue;
            if (null != this.prof) {
                this.prof.saveXML();
            }
            if (null != this.hist) {
                this.hist.saveXML();
            }
            if (null == this.histBlobs) continue;
            this.histBlobs.saveXML();
        } while (n3 < n2);
        if (drawingMode == DrawingMode.BLOB_PAIR) {
            glassPane.setDrawingMode(DrawingMode.BLOB_HOVER);
        } else if (drawingMode == DrawingMode.STAR_PAIR) {
            glassPane.setDrawingMode(DrawingMode.STAR_CHART);
        }
        if (bl2) {
            glassPane.overlayMeridian(d);
            glassPane.repaint();
        }
    }

    private double scaleCalib(double d, Calibration calibration, int n) {
        double d2 = calibration.getScale();
        switch (n) {
            case 3: {
                return d * d2 * d2 * d2;
            }
            case 2: {
                return d * d2 * d2;
            }
            case -1: {
                return d / d2;
            }
        }
        return d * d2;
    }

    public static String powerPrefix(int n) {
        switch (n) {
            case 3: {
                return " cu. ";
            }
            case 2: {
                return " sq. ";
            }
            case -1: {
                return " reciprocal ";
            }
        }
        return " ";
    }
}

