/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.image.BufferedImage;
import java.io.File;
import net.grelf.FileIO;
import net.grelf.PointFloat;
import net.grelf.Util;
import net.grelf.grip.BatchMetadata;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.CometFrame;
import net.grelf.grip.Config;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.grip.StarSegmenter;
import net.grelf.image.Image;
import net.grelf.image.Image32;
import net.grelf.image.ImageLoader;
import net.grelf.image.IncompatibleImageException;

public class CometProcessor
implements Runnable {
    private File[] files;
    private boolean neutraliseBackground;
    private boolean correctBackground;
    private boolean doGnomonic;
    private int focalLength_mm;
    private double detectorWidth_mm;
    private double detectorHeight_mm;
    private Image darkIm;
    private Image flatIm;
    private int imNo = 0;
    private int skippedFrames = 0;
    private Image32 accum;
    private PointFloat cometPt0;
    private BatchMetadata batchMetadata = new BatchMetadata();

    public CometProcessor(File[] fileArray, String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.files = fileArray;
        if (null != string && string.length() > 0) {
            this.darkIm = ImageLoader.load(string);
        }
        if (null != string2 && string2.length() > 0) {
            this.flatIm = ImageLoader.load(string2);
        }
        this.neutraliseBackground = bl;
        this.correctBackground = bl2;
        this.doGnomonic = bl3;
        if (bl3) {
            try {
                this.focalLength_mm = Integer.parseInt(string3);
                this.detectorWidth_mm = Double.parseDouble(Config.getValue("Detector.width.mm.value"));
                this.detectorHeight_mm = Double.parseDouble(Config.getValue("Detector.height.mm.value"));
            }
            catch (NumberFormatException numberFormatException) {
                this.focalLength_mm = 100;
                Util.warning("Error", "Invalid focal length" + string3);
            }
        }
    }

    @Override
    public void run() {
        if (null == this.files) {
            this.files = FileIO.selectInputFiles("Images to process");
        }
        if (null != this.files) {
            this.imNo = 0;
            this.processNext();
        }
    }

    protected void process(PointFloat pointFloat, BufferedImage bufferedImage) {
        if (this.imNo >= 0) {
            block8: {
                if (null != pointFloat && null != bufferedImage) {
                    try {
                        if (null == this.accum) {
                            this.cometPt0 = pointFloat;
                            this.accum = new Image32(bufferedImage);
                            break block8;
                        }
                        float f = this.cometPt0.x - pointFloat.x;
                        float f2 = this.cometPt0.y - pointFloat.y;
                        this.accum.addTranslated(bufferedImage, f, f2);
                    }
                    catch (IncompatibleImageException incompatibleImageException) {
                        Util.warning("Error", "{0} - {1}", this.files[this.imNo].getPath(), incompatibleImageException.toString());
                    }
                } else {
                    ++this.skippedFrames;
                }
            }
            ++this.imNo;
            if (this.imNo < this.files.length) {
                this.processNext();
            } else {
                this.displayResult();
                Util.message("Done", this.files.length + " frames processed");
            }
        }
    }

    private void processNext() {
        Object object;
        File file = this.files[this.imNo];
        CometFrame cometFrame = new CometFrame(this, file);
        this.batchMetadata.add(file, cometFrame.getImPane().getImage());
        if (null != this.darkIm) {
            try {
                cometFrame.getImPane().getImage().subtractToZero(this.darkIm);
            }
            catch (IncompatibleImageException incompatibleImageException) {
                Util.warning("Error", "Incompatible dark frame");
            }
        }
        if (null != this.flatIm) {
            cometFrame.getImPane().getImage().divideByFlatField(this.flatIm);
        }
        if (this.neutraliseBackground) {
            cometFrame.neutraliseBackground();
        }
        if (this.correctBackground) {
            cometFrame.correctBackground();
        }
        if (this.doGnomonic) {
            ImPane imPane = cometFrame.getImPane();
            object = imPane.getImage();
            object = object.inverseGnomonicProjection(this.focalLength_mm, this.detectorWidth_mm, this.detectorHeight_mm);
            imPane.setImage((Image)object);
        }
        try {
            cometFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            StarSegmenter.segment(cometFrame, Integer.parseInt(Config.getValue("StarSegmentDifference.value")), Integer.parseInt(Config.getValue("StarSegmentRadius.value")));
            boolean bl = false;
            object = cometFrame.detectBlobs(bl);
            if (null != object) {
                cometFrame.setBlobMeases((BlobMeasList)object);
                cometFrame.getGP().setDrawingMode(DrawingMode.BLOB_HOVER);
                cometFrame.updatePanel(this.imNo, this.files.length, this.skippedFrames);
                cometFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            } else {
                Util.warning(cometFrame, "Error", (Object)"No stars detected");
                this.imNo = -1;
                cometFrame.dispose();
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = "Config values missing for StarSegmenter parameters.\nTry deleting file grip.properties and re-running GRIP.";
            Util.warning("Error", object);
            this.imNo = -1;
            cometFrame.dispose();
        }
    }

    private void displayResult() {
        String string = this.files[0].getPath();
        String string2 = this.files[this.files.length - 1].getName();
        String string3 = FileIO.removeExtension(string) + "-" + FileIO.removeExtension(string2) + "_comet.fits";
        this.batchMetadata.setImageMetadata(this.accum, this.files.length - this.skippedFrames);
        this.accum.save(string3);
        ImFrame imFrame = new ImFrame(string3, this.accum);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Of the ");
        stringBuffer.append(this.files.length);
        stringBuffer.append(" images, ");
        stringBuffer.append(this.skippedFrames);
        if (1 == this.skippedFrames) {
            stringBuffer.append(" was");
        } else {
            stringBuffer.append(" were");
        }
        stringBuffer.append(" skipped");
        Util.message(imFrame, "Information", stringBuffer.toString());
    }
}

