/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.InadequateDataException;
import net.grelf.Util;
import net.grelf.astro.MagnitudeBands;
import net.grelf.astro.MagnitudeChart;
import net.grelf.astro.MagnitudeGraph;
import net.grelf.astro.MagnitudeTable;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.Star;
import net.grelf.astro.StarChart;
import net.grelf.grip.BlobFrame;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;

public class BlobMenu
extends JMenu
implements ActionListener,
MenuListener {
    private ImFrame imframe;
    private BlobMeas meas;
    private JMenuItem itemPosition;
    private JMenuItem itemBands;
    private JMenuItem itemEstimate;
    private JMenuItem itemTable;
    private JMenuItem itemSave;
    private static StarChart chart = null;
    private static MagnitudeBands magnitudeBands = null;

    public void reviseSettings() {
        if (null == this.meas.blob.getBackgroundDisc() || null != this.meas.blob.getBrightnessDisc()) {
            // empty if block
        }
        this.itemTable.setEnabled(true);
        Star star = this.meas.getStar();
        this.itemBands.setEnabled(null != star);
        if (null != star && 0 < star.getId().length() && null == star.getMagnitude()) {
            this.itemEstimate.setEnabled(true);
        } else {
            this.itemEstimate.setEnabled(false);
        }
        if (null != star && 0 < star.getId().length() && null == star.getPosition()) {
            this.itemPosition.setEnabled(true);
        } else {
            this.itemPosition.setEnabled(false);
        }
        this.itemSave.setEnabled(true);
    }

    public BlobMenu(BlobFrame blobFrame) {
        super("Blobs/stars");
        this.imframe = blobFrame;
        this.meas = blobFrame.getBlobMeas();
        this.setMnemonic('B');
        int n = this.imframe.getParentFrame().getImPane().getImage().getNBands();
        if (null == magnitudeBands || magnitudeBands.getNBands() != n) {
            magnitudeBands = new MagnitudeBands(n);
        }
        this.itemBands = Util.menuItem(this, "Set wavelength bands for estimating", "bands", 87, 0);
        this.add(this.itemBands);
        this.itemEstimate = Util.menuItem(this, "Estimate magnitude from other blobs", "estimate", 69, 0);
        this.add(this.itemEstimate);
        this.itemEstimate.setToolTipText("Estimates all blobs/stars with id but no magnitude");
        this.itemPosition = Util.menuItem(this, "Measure position from reference stars", "position", 69, 0);
        this.add(this.itemPosition);
        this.itemPosition.setToolTipText("Measures all blobs/stars with id but no RA/Dec");
        this.itemTable = Util.menuItem(this, "Tabulate identified blobs", "table", 84, 0);
        this.add(this.itemTable);
        this.itemSave = Util.menuItem(this, "Save all blob/star data", "save", 83, 0);
        this.add(this.itemSave);
        this.itemSave.setToolTipText("Save parent image's blob data as XML .blobs file");
        this.addSeparator();
        this.add(Util.menuItem(this, "Help about this menu", "help", 0, 0));
        this.addMenuListener(this);
        this.reviseSettings();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("bands")) {
            magnitudeBands.showDialogue(this.imframe);
        } else if (string.equals("estimate")) {
            try {
                ImFrame imFrame = this.imframe.getParentFrame();
                BlobMeasList blobMeasList = imFrame.getBlobMeases();
                MagnitudeGraph magnitudeGraph = new MagnitudeGraph(this.imframe, "Stellar brightnesses v. magnitudes", blobMeasList, magnitudeBands, imFrame.getFilePath(), imFrame.getImageTimeSpan());
                new MagnitudeChart(chart, "Measured stars", blobMeasList, magnitudeGraph.isAccurate());
                magnitudeGraph.showGraph();
            }
            catch (InadequateDataException inadequateDataException) {
                Util.warning("Sorry", inadequateDataException.getMessage());
            }
        } else if (string.equals("help")) {
            HelpMenu.help("pages/blob_menu.html");
        } else if (string.equals("position")) {
            Star star = this.meas.getStar();
            if (null != star) {
                BlobMeasList blobMeasList;
                ImFrame imFrame = this.imframe.getParentFrame();
                SkyPoint skyPoint = star.measurePosition(imFrame, blobMeasList = imFrame.getBlobMeases());
                if (null == skyPoint) {
                    Util.warning(imFrame, "Measured position", (Object)"Sorry, not measured");
                } else {
                    JTextArea jTextArea = new JTextArea(skyPoint.toString());
                    Util.message(imFrame, "Measured position (copyable text)", jTextArea);
                }
            }
        } else if (string.equals("save")) {
            this.imframe.getParentFrame().saveBlobMeasList();
        } else if (string.equals("table")) {
            BlobMeasList blobMeasList = this.imframe.getParentFrame().getBlobMeases();
            new MagnitudeTable(this.imframe, "Identified blobs", blobMeasList).showTable();
        }
        this.reviseSettings();
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.reviseSettings();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }
}

