/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.util.ArrayList;
import java.util.List;
import net.grelf.VectorFloat;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.Connection;
import net.grelf.grip.ConnectionList;
import net.grelf.grip.MatchPair;

public class Analyser {
    private Analyser() {
    }

    public static List<ConnectionList> getSortedConnections(BlobMeasList blobMeasList, int n) {
        ArrayList<ConnectionList> arrayList = new ArrayList<ConnectionList>();
        int n2 = 0;
        for (BlobMeas blobMeas : blobMeasList) {
            int n3 = 0;
            ConnectionList connectionList = new ConnectionList();
            for (BlobMeas blobMeas2 : blobMeasList) {
                if (n2 != n3) {
                    VectorFloat vectorFloat = new VectorFloat(blobMeas.centre, blobMeas2.centre);
                    connectionList.insert(new Connection(vectorFloat, n2, n3));
                }
                if (++n3 <= n) continue;
                break;
            }
            arrayList.add(connectionList);
            if (++n2 <= n) continue;
            break;
        }
        return arrayList;
    }

    public static List<MatchPair> matchBrightest(List<List<ConnectionList>> list) {
        ArrayList<MatchPair> arrayList = new ArrayList<MatchPair>();
        int n = list.size();
        for (int i = 0; i < n - 1; ++i) {
            List<ConnectionList> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                ConnectionList connectionList = list2.get(j);
                boolean bl = false;
                int n2 = i + 1;
                while (!bl && n2 < n) {
                    List<ConnectionList> list3 = list.get(n2);
                    for (int k = 0; k < list3.size(); ++k) {
                        ConnectionList connectionList2 = list3.get(k);
                        if (!Analyser.vectorMatch(connectionList, connectionList2)) continue;
                        arrayList.add(new MatchPair(i, j, n2, k));
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    public static boolean vectorMatch(ConnectionList connectionList, ConnectionList connectionList2) {
        int n = 0;
        block0: for (Connection connection : connectionList) {
            for (Connection connection2 : connectionList2) {
                if (!connection.vector.equals(connection2.vector)) continue;
                ++n;
                continue block0;
            }
        }
        return n > connectionList.size() / 2;
    }
}

