/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import net.grelf.Angle;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.JulianDate;
import net.grelf.astro.RA;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.Star;

public abstract class StarChartLoader {
    protected Epoch equinox = Epoch.J2000;
    protected JulianDate epoch = new JulianDate();
    protected double cos90ap;
    protected double sin90ap;
    protected double cosdp;
    protected double sindp;
    protected double sinFieldRadius;

    public Epoch getEquinox() {
        return this.equinox;
    }

    public JulianDate getEpoch() {
        return this.epoch;
    }

    protected void initialiseChartCoordinates(SkyPoint skyPoint, double d) {
        RA rA = skyPoint.getRA();
        Dec dec = skyPoint.getDec();
        Angle angle = new Angle(90.0, Angle.Units.DEGREES).subtract(rA);
        this.cos90ap = angle.cos();
        this.sin90ap = angle.sin();
        this.cosdp = dec.cos();
        this.sindp = -dec.sin();
        Angle angle2 = new Angle(d, Angle.Units.DEGREES);
        this.sinFieldRadius = angle2.sin();
    }

    protected void calculateChartCoordinates(Star star) {
        SkyPoint skyPoint = star.getPosition();
        RA rA = skyPoint.getRA();
        Dec dec = skyPoint.getDec();
        double d = dec.cos();
        double d2 = rA.cos() * d;
        double d3 = rA.sin() * d;
        double d4 = dec.sin();
        double d5 = this.cos90ap * d2 - this.sin90ap * d3;
        double d6 = this.sindp * this.sin90ap * d2 + this.sindp * this.cos90ap * d3 + this.cosdp * d4;
        star.xdd = d5;
        star.zdd = d6;
    }
}

