/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import net.grelf.Angle;
import net.grelf.astro.BodyKind;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.JulianDate;
import net.grelf.astro.RA;
import net.grelf.astro.SkyVector;

public class SkyPoint
implements Cloneable,
Serializable {
    private RA ra;
    private Dec dec;
    private Epoch equinox;
    protected double x;
    protected double y;
    protected double z;
    private static final double EPSILON = 1.0E-7;
    private static final double ARCSECS_TO_DEGS = 2.777777777777778E-4;

    public RA getRA() {
        return this.ra;
    }

    public Dec getDec() {
        return this.dec;
    }

    @Deprecated
    public Epoch getEpoch() {
        return this.equinox;
    }

    public Epoch getEquinox() {
        return this.equinox;
    }

    public SkyPoint(RA rA, Dec dec, Epoch epoch) {
        this.ra = rA;
        this.dec = dec;
        this.equinox = epoch;
        this.computeXYZ();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SkyPoint skyPoint = (SkyPoint)object;
        if (!skyPoint.ra.equals(this.ra)) {
            return false;
        }
        if (!skyPoint.dec.equals(this.dec)) {
            return false;
        }
        if (!skyPoint.equinox.equals(this.equinox)) {
            return false;
        }
        if (Math.abs(skyPoint.x - this.x) > 1.0E-7) {
            return false;
        }
        if (Math.abs(skyPoint.y - this.y) > 1.0E-7) {
            return false;
        }
        return !(Math.abs(skyPoint.z - this.z) > 1.0E-7);
    }

    public int hashCode() {
        return this.ra.hashCode() * 17 + this.dec.hashCode() * 41 + this.equinox.hashCode() * 83;
    }

    public SkyPoint clone() {
        return new SkyPoint(this.ra.clone(), this.dec.clone(), this.equinox.clone());
    }

    private void computeXYZ() {
        double d = this.dec.cos();
        this.x = this.ra.cos() * d;
        this.y = this.ra.sin() * d;
        this.z = this.dec.sin();
    }

    public void changeEquinoxLowAccuracy(Epoch epoch) {
        float f = epoch.getYear() - this.equinox.getYear();
        if (1.0E-4f > Math.abs(f)) {
            return;
        }
        double d = (double)f * (3.073 + 1.3362 * this.ra.sin() * this.dec.tan());
        RA rA = new RA(this.ra.toHours(), 0.0, d);
        double d2 = (double)f * 20.043 * this.ra.cos();
        Dec dec = new Dec(this.dec.toDegrees() + d2 / 3600.0);
        this.ra = rA;
        this.dec = dec;
        this.equinox = epoch;
        this.computeXYZ();
    }

    public void changeEquinox(Epoch epoch) {
        double d = this.equinox.getJulianDate().toDouble();
        double d2 = epoch.getJulianDate().toDouble();
        double d3 = (d - 2451545.0) / 36525.0;
        double d4 = (d2 - d) / 36525.0;
        double d5 = d3 * d3;
        double d6 = d4 * d4;
        double d7 = d6 * d4;
        Angle angle = new Angle(((2306.2181 + 1.39656 * d3 - 1.39E-4 * d5) * d4 + (0.30188 - 3.44E-4 * d3) * d6 + 0.017998 * d7) * 2.777777777777778E-4, Angle.Units.DEGREES);
        Angle angle2 = new Angle(((2306.2181 + 1.39656 * d3 - 1.39E-4 * d5) * d4 + (1.09468 + 6.6E-5 * d3) * d6 + 0.018203 * d7) * 2.777777777777778E-4, Angle.Units.DEGREES);
        Angle angle3 = new Angle(((2004.3109 - 0.8533 * d3 - 2.17E-4 * d5) * d4 - (0.42665 + 2.17E-4 * d3) * d6 - 0.041833 * d7) * 2.777777777777778E-4, Angle.Units.DEGREES);
        RA rA = this.ra;
        Dec dec = this.dec;
        double d8 = dec.cos();
        double d9 = dec.sin();
        Angle angle4 = rA.add(angle).in360();
        double d10 = d8 * angle4.cos();
        double d11 = angle3.cos();
        double d12 = angle3.sin();
        double d13 = d8 * angle4.sin();
        double d14 = d11 * d10 - d12 * d9;
        double d15 = d12 * d10 + d11 * d9;
        this.ra = new RA(angle2.add(Angle.atan2(d13, d14)).in360());
        double d16 = dec.toDegrees();
        this.dec = d16 > -85.0 && d16 < 85.0 ? new Dec(Angle.asin(d15)) : new Dec(Angle.acos(StrictMath.sqrt(d13 * d13 + d14 * d14)));
        this.equinox = epoch;
        this.computeXYZ();
    }

    public SkyVector calculateSeparation(SkyPoint skyPoint) {
        if (null != skyPoint.equinox && null != this.equinox && !skyPoint.equinox.equals(this.equinox)) {
            skyPoint.changeEquinox(this.equinox);
        }
        Angle angle = this.ra.clone().subtract(skyPoint.ra);
        double d = skyPoint.dec.cos();
        double d2 = this.dec.cos();
        double d3 = angle.cos();
        double d4 = skyPoint.dec.sin();
        double d5 = this.dec.sin();
        double d6 = angle.sin();
        double d7 = d * d5 - d4 * d2 * d3;
        double d8 = d2 * d6;
        double d9 = d4 * d5 + d * d2 * d3;
        Angle angle2 = Angle.atan2(StrictMath.sqrt(d7 * d7 + d8 * d8), d9);
        Angle angle3 = Angle.atan2(-d6, d2 * d4 / d - d5 * d3).in360();
        return new SkyVector(angle2, angle3);
    }

    public SkyPoint offset(SkyVector skyVector) {
        Angle angle = skyVector.getSeparation();
        Angle angle2 = skyVector.getPa();
        Angle angle3 = new Angle(Math.PI - angle2.getRadians(), Angle.Units.RADIANS);
        double d = this.dec.sin();
        double d2 = this.dec.cos();
        double d3 = angle.sin();
        double d4 = angle.cos();
        Dec dec = new Dec(Angle.asin(d * d4 + d2 * d3 * angle3.cos()));
        RA rA = new RA(this.ra.add(Angle.atan2(angle3.sin() * d3 * d2, d4 - d * dec.sin())).in360());
        return new SkyPoint(rA, dec, this.equinox);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RA ");
        stringBuffer.append(this.ra.toString());
        stringBuffer.append(" Dec ");
        stringBuffer.append(this.dec.toString());
        stringBuffer.append(" (");
        stringBuffer.append(this.equinox.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toFoldedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RA ");
        stringBuffer.append(this.ra.toString());
        stringBuffer.append(string);
        stringBuffer.append(" Dec ");
        stringBuffer.append(this.dec.toString());
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(this.equinox.toString());
        stringBuffer.append(")");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public StringBuffer toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<RA>");
        stringBuffer.append(this.getRA().toString());
        stringBuffer.append("</RA><Dec>");
        stringBuffer.append(this.getDec().toString());
        stringBuffer.append("</Dec><Epoch>");
        stringBuffer.append(this.getEquinox().toString());
        stringBuffer.append("</Epoch>");
        return stringBuffer;
    }

    public double[] calculateRiseTransitSet(JulianDate julianDate, BodyKind bodyKind, Angle angle) {
        double d;
        double d2;
        double d3 = (double)StrictMath.round(julianDate.toDouble()) + 0.5;
        double d4 = new JulianDate(d3).toMeanSiderealTimeAtGreenwichInDegrees();
        double d5 = -0.5667;
        switch (bodyKind) {
            case SUN: {
                d5 = -0.8333;
                break;
            }
            case MOON: {
                d5 = 0.125;
                break;
            }
            default: {
                d5 = -0.5667;
            }
        }
        Angle angle2 = new Angle(d5, Angle.Units.DEGREES);
        Dec dec = this.getDec();
        double d6 = angle.sin() * dec.sin();
        Angle angle3 = Angle.acos((angle2.sin() - d6) / angle.cos() * dec.cos());
        double d7 = (this.getRA().toDegrees() - d4) / 360.0;
        if (d6 < -1.0 || d6 > 1.0) {
            d2 = -1.0;
            d = -1.0;
        } else {
            double d8 = angle3.getDegrees() / 360.0;
            d = this.in01(d7 - d8);
            d2 = this.in01(d7 + d8);
        }
        double[] dArray = new double[]{d, this.in01(d7), d2};
        return dArray;
    }

    private double in01(double d) {
        if (d > 1.0) {
            return d - 1.0;
        }
        if (d < 0.0) {
            return d + 1.0;
        }
        return d;
    }
}

