/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import net.grelf.Fitter;
import net.grelf.Util;

public class Fitter_
implements Fitter {
    private boolean fitted = false;
    private double m;
    private double c;
    private double sigmaM;
    private double sigmaC;
    private double chiSq;
    private double q;
    private static final int MAX_ITERATIONS = 100;
    private static final double EPSILON = 1.0E-7;
    private static final double MIN_VALUE = 1.0E-30;
    private static final double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};

    @Override
    public boolean isFitted() {
        return this.fitted;
    }

    @Override
    public double getM() {
        return this.m;
    }

    @Override
    public double getC() {
        return this.c;
    }

    @Override
    public double getSigmaM() {
        return this.sigmaM;
    }

    @Override
    public double getSigmaC() {
        return this.sigmaC;
    }

    @Override
    public double getChiSq() {
        return this.chiSq;
    }

    @Override
    public double getQ() {
        return this.q;
    }

    @Override
    public void leastSquaresStraightLine(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        int n;
        int n2;
        int n3 = dArray.length;
        if (n3 != dArray2.length) {
            Util.warning("Sorry", "The data arrays for least squares fitting are of different lengths");
            return;
        }
        if (null != dArray3 && n3 != dArray3.length) {
            Util.warning("Sorry", "The sigmaY array is not the same length as the data arrays.");
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        this.m = 0.0;
        if (null == dArray3) {
            for (n2 = 0; n2 < n3; ++n2) {
                d2 += dArray[n2];
                d3 += dArray2[n2];
            }
            d4 = n3;
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                double d5 = 1.0 / (dArray3[n2] * dArray3[n2]);
                d4 += d5;
                d2 += dArray[n2] * d5;
                d3 += dArray2[n2] * d5;
            }
        }
        double d6 = d2 / d4;
        double d7 = 0.0;
        if (null == dArray3) {
            for (n = 0; n < n3; ++n) {
                d = dArray[n] - d6;
                d7 += d * d;
                this.m += d * dArray2[n];
            }
        } else {
            for (n = 0; n < n3; ++n) {
                d = (dArray[n] - d6) / dArray3[n];
                d7 += d * d;
                this.m += d * dArray2[n] / dArray3[n];
            }
        }
        this.m /= d7;
        this.c = (d3 - d2 * this.m) / d4;
        this.sigmaM = StrictMath.sqrt(1.0 / d7);
        this.sigmaC = StrictMath.sqrt((1.0 + d2 * d2 / (d4 * d7)) / d4);
        this.chiSq = 0.0;
        if (null == dArray3) {
            for (n = 0; n < n3; ++n) {
                d = dArray2[n] - (this.m * dArray[n] + this.c);
                this.chiSq += d * d;
            }
            double d8 = StrictMath.sqrt(this.chiSq / (double)(n3 - 2));
            this.sigmaM *= d8;
            this.sigmaC *= d8;
            this.q = 1.0;
        } else {
            for (n = 0; n < n3; ++n) {
                d = (dArray2[n] - (this.m * dArray[n] + this.c)) / dArray3[n];
                this.chiSq += d * d;
            }
            this.q = this.gammaQ(0.5 * (double)(n3 - 2), 0.5 * this.chiSq);
        }
        this.fitted = true;
    }

    @Override
    public double y(double d) {
        if (!this.fitted) {
            return 0.0;
        }
        return this.m * d + this.c;
    }

    @Override
    public double x(double d) {
        if (!this.fitted) {
            return 0.0;
        }
        return (d - this.c) / this.m;
    }

    private double gammaQ(double d, double d2) {
        if (d2 < 0.0 || d <= 0.0) {
            Util.logWarning("Fitter: invalid arguments to gammaQ ()");
            return 1.0;
        }
        if (d2 < d + 1.0) {
            return 1.0 - this.gser(d, d2);
        }
        return this.gcf(d, d2);
    }

    private double gser(double d, double d2) {
        double d3;
        if (d2 < 0.0) {
            Util.logWarning("Fitter: x < 0 in gser ()");
            return 0.0;
        }
        double d4 = this.lnGamma(d);
        double d5 = d;
        double d6 = d3 = 1.0 / d;
        for (int i = 1; i <= 100; ++i) {
            d6 += (d3 *= d2 / (d5 += 1.0));
            if (!(StrictMath.abs(d3) < StrictMath.abs(d6) * 1.0E-7)) continue;
            return d6 * StrictMath.exp(-d2 + d * StrictMath.log(d2) - d4);
        }
        Util.logWarning("Fitter: settings exceeded in gamser ()");
        return 0.0;
    }

    private double gcf(double d, double d2) {
        int n;
        double d3;
        double d4 = this.lnGamma(d);
        double d5 = d2 + 1.0 - d;
        double d6 = Double.MAX_VALUE;
        double d7 = d3 = 1.0 / d5;
        for (n = 1; n <= 100; ++n) {
            double d8 = (double)(-n) * ((double)n - d);
            if (StrictMath.abs(d3 = d8 * d3 + (d5 += 2.0)) < 1.0E-30) {
                d3 = Double.MIN_VALUE;
            }
            if (StrictMath.abs(d6 = d5 + d8 / d6) < 1.0E-30) {
                d6 = 1.0E-30;
            }
            d3 = 1.0 / d3;
            double d9 = d3 * d6;
            d7 *= d9;
            if (StrictMath.abs(d9 - 1.0) < 1.0E-7) break;
        }
        if (n > 100) {
            Util.logWarning("Fitter: settings exceeded in gcf ()");
        }
        return StrictMath.exp(-d2 + d * StrictMath.log(d2) - d4) * d7;
    }

    private double lnGamma(double d) {
        double d2 = d;
        double d3 = d + 5.5;
        d3 -= (d + 0.5) * StrictMath.log(d3);
        double d4 = 1.000000000190015;
        for (int i = 0; i < cof.length; ++i) {
            d4 += cof[i] / (d2 += 1.0);
        }
        return -d3 + StrictMath.log(2.5066282746310007 * d4 / d);
    }
}

