/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.grelf.Util;

public class FileIO {
    private static final JFileChooser jfc = new JFileChooser();
    private static FileFilter currentFilter;

    private FileIO() {
    }

    public static void copyFile(String string, String string2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        while (-1 != (n = bufferedInputStream.read())) {
            bufferedOutputStream.write(n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (-1 == n) {
            return "";
        }
        return string.substring(n);
    }

    public static boolean isXmlFile(String string) {
        try {
            char[] cArray = new char[5];
            FileReader fileReader = new FileReader(string);
            int n = fileReader.read(cArray, 0, 5);
            fileReader.close();
            if (5 != n) {
                return false;
            }
            String string2 = new String(cArray, 0, 5);
            if (string2.equals("<?xml")) {
                return true;
            }
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
        }
        return false;
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        if (-1 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String selectInputFile(String string) {
        return FileIO.selectInputFile(string, null, null, null);
    }

    public static String selectInputFile(String string, String string2) {
        return FileIO.selectInputFile(string, string2, null, null);
    }

    public static String selectInputFile(String string, String string2, FileFilter[] fileFilterArray) {
        return FileIO.selectInputFile(string, string2, fileFilterArray, null);
    }

    public static String selectInputFile(String string, String string2, FileFilter[] fileFilterArray, String string3) {
        jfc.setDialogTitle(string);
        if (null != string3) {
            jfc.setSelectedFile(new File(string3));
        }
        if (null != string2) {
            jfc.setCurrentDirectory(new File(string2));
        }
        jfc.setFileSelectionMode(0);
        jfc.resetChoosableFileFilters();
        if (null != fileFilterArray) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                jfc.addChoosableFileFilter(fileFilterArray[i]);
            }
        }
        if (0 == jfc.showOpenDialog(null)) {
            return jfc.getSelectedFile().getPath();
        }
        return null;
    }

    public static File[] selectInputFiles(String string) {
        return FileIO.selectInputFiles(string, null, null);
    }

    public static File[] selectInputFiles(String string, String string2) {
        return FileIO.selectInputFiles(string, null, null);
    }

    public static File[] selectInputFiles(String string, String string2, FileFilter[] fileFilterArray) {
        jfc.setDialogTitle(string);
        if (null != string2) {
            jfc.setCurrentDirectory(new File(string2));
        }
        jfc.setFileSelectionMode(0);
        jfc.setMultiSelectionEnabled(true);
        jfc.resetChoosableFileFilters();
        if (null != fileFilterArray) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                jfc.addChoosableFileFilter(fileFilterArray[i]);
            }
        }
        if (0 == jfc.showOpenDialog(null)) {
            return jfc.getSelectedFiles();
        }
        return null;
    }

    public static String selectOutputFile(String string) {
        return FileIO.selectOutputFile(string, null, null, null);
    }

    public static String selectOutputFile(String string, String string2) {
        return FileIO.selectOutputFile(string, string2, null, null);
    }

    public static String selectOutputFile(String string, String string2, FileFilter[] fileFilterArray) {
        return FileIO.selectOutputFile(string, string2, fileFilterArray, null);
    }

    public static String selectOutputFile(String string, String string2, FileFilter[] fileFilterArray, String string3) {
        currentFilter = null;
        jfc.setDialogTitle(string);
        if (null != string3) {
            jfc.setSelectedFile(new File(string3));
        }
        if (null != string2) {
            jfc.setCurrentDirectory(new File(string2));
        }
        jfc.setFileSelectionMode(0);
        jfc.resetChoosableFileFilters();
        if (null != fileFilterArray) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                jfc.addChoosableFileFilter(fileFilterArray[i]);
            }
        }
        if (0 == jfc.showSaveDialog(null)) {
            File file = jfc.getSelectedFile();
            currentFilter = jfc.getFileFilter();
            if (!file.exists()) {
                return file.getPath();
            }
            if (Util.confirm(jfc, "Overwrite?", "<html>" + file.getName() + "<br> already exists. Replace it?</html>")) {
                return file.getPath();
            }
        }
        return null;
    }

    public static FileFilter getCurrentFilter() {
        return currentFilter;
    }

    static {
        jfc.setCurrentDirectory(new File(System.getProperty("user.dir")));
        currentFilter = null;
    }
}

