/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.Serializable;
import net.grelf.Angle;

public class Complex
implements Cloneable,
Serializable {
    public double re;
    public double im;

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public Complex clone() {
        return new Complex(this.re, this.im);
    }

    public String toString() {
        if (this.im >= 0.0) {
            return this.re + " + " + this.im + "i";
        }
        return this.re + " - " + -this.im + "i";
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Complex complex = (Complex)object;
        if (StrictMath.abs(this.re - complex.re) > this.re * 1.0E-15) {
            return false;
        }
        return !(StrictMath.abs(this.im - complex.im) > this.im * 1.0E-15);
    }

    public int hashCode() {
        return (int)(1.7171717E7 * this.re - 232323.0 * this.im);
    }

    public double mod() {
        return StrictMath.sqrt(this.re * this.re + this.im * this.im);
    }

    public Angle arg() {
        return Angle.atan2(this.im, this.re);
    }

    public Complex conjugate() {
        this.im = -this.im;
        return this;
    }

    public Complex assign(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
        return this;
    }

    public Complex add(Complex complex) {
        this.re += complex.re;
        this.im += complex.im;
        return this;
    }

    public Complex add(double d) {
        this.re += d;
        return this;
    }

    public Complex subtract(Complex complex) {
        this.re -= complex.re;
        this.im -= complex.im;
        return this;
    }

    public Complex subtract(double d) {
        this.re -= d;
        return this;
    }

    public Complex multiply(Complex complex) {
        double d = this.re * complex.re - this.im * complex.im;
        this.im = this.re * complex.im + this.im * complex.re;
        this.re = d;
        return this;
    }

    public Complex multiply(double d) {
        this.re *= d;
        this.im *= d;
        return this;
    }

    public Complex divide(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        double d2 = this.re * complex.re + this.im * complex.im;
        this.im = (this.im * complex.re - this.re * complex.im) / d;
        this.re = d2 / d;
        return this;
    }

    public Complex divide(double d) {
        this.re /= d;
        this.im /= d;
        return this;
    }

    public static Complex expi(double d) {
        return new Complex(StrictMath.cos(d), StrictMath.sin(d));
    }

    public static Complex expi(Angle angle) {
        return new Complex(angle.cos(), angle.sin());
    }
}

