/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.srf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.srf.SRFImageReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;

public class SRFImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = SRFImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public SRFImageReaderSpi() {
        super("SRF", "srf", "image/x-sony-srf", SRFImageReader.class);
    }

    public String getDescription(Locale locale) {
        return "Standard SRF Image Reader";
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new SRFImageReader(this, extension);
    }

    public boolean canDecodeInput(RAWImageInputStream iis) throws IOException {
        iis.seek(0L);
        long ifdOffset = TIFFImageReaderSupport.processHeader(iis, null);
        IFD primaryIFD = new IFD();
        primaryIFD.load(iis, ifdOffset);
        if (primaryIFD.isDNGVersionAvailable()) {
            return false;
        }
        String make = primaryIFD.getMake();
        String model = primaryIFD.getModel();
        if (make == null || !make.toUpperCase().startsWith("SONY") || model == null || model.toUpperCase().startsWith("DSLR-A100")) {
            logger.fine("SRFImageReaderSpi giving up on: '%s' / '%s'", make, model);
            return false;
        }
        return true;
    }
}

