/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.Curve;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.demosaic.DemosaicFilterProcessor;
import it.tidalwave.imageio.util.Logger;

public class DemosaicOperation
extends OperationSupport {
    private static final Logger logger = DemosaicOperation.getLogger(DemosaicOperation.class);
    protected String algorithm;
    protected DemosaicFilterProcessor processor;
    private int[] cfaPattern;
    private String cfaPatternAsString;

    public DemosaicOperation() {
        super(Source.Type.RAW);
    }

    public void process(PipelineArtifact artifact) throws Exception {
        logger.fine("process()", new Object[0]);
        this.cfaPattern = artifact.getCFAPattern();
        String cfaPatternAsString = artifact.getCFAPatternAsString();
        this.algorithm = this.chooseDemosaicAlgorithm(cfaPatternAsString);
        double redCoeff = artifact.getRedCoefficient();
        double greenCoeff = artifact.getGreenCoefficient();
        double blueCoeff = artifact.getBlueCoefficient();
        double blackLevel = artifact.getBlackLevel();
        Curve curve = artifact.getCurve();
        this.processor = new DemosaicFilterProcessor(cfaPatternAsString, this.algorithm, redCoeff, greenCoeff, blueCoeff, blackLevel, curve);
        logger.finer("Bayer pattern: %s", cfaPatternAsString);
        this.processor.process(artifact.getImage());
    }

    protected String chooseDemosaicAlgorithm(String cfaPatternAsString) {
        if (!cfaPatternAsString.equals("GRBG")) {
            return "Bilinear";
        }
        return "PixelGrouping";
    }
}

