/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class CurveOperation
extends OperationSupport {
    private static final Logger logger = CurveOperation.getLogger(CurveOperation.class);
    protected static final double MAX_LEVEL = 65535.0;

    public CurveOperation() {
        super(Source.Type.RAW);
    }

    public void process(@Nonnull PipelineArtifact artifact) {
        logger.fine("process(%s)", artifact);
        double[] normalizationFactor = this.getNormalizationFactor(artifact);
        artifact.multiplyRedCoefficient(normalizationFactor[0]);
        artifact.multiplyGreenCoefficient(normalizationFactor[1]);
        artifact.multiplyBlueCoefficient(normalizationFactor[2]);
    }

    protected double[] getNormalizationFactor(@Nonnull PipelineArtifact artifact) {
        logger.fine("getNormalizationFactor(%s)", artifact);
        int[] blackLevel = this.getBlackLevel(artifact);
        double whiteLevel = this.getWhiteLevel(artifact);
        double[] normalizationFactor = new double[3];
        logger.finer(">>>> blackLevel: %s", Arrays.toString(blackLevel));
        logger.finer(">>>> whiteLevel: %f", whiteLevel);
        for (int i = 0; i < normalizationFactor.length; ++i) {
            normalizationFactor[i] = 65535.0 / (whiteLevel - (double)blackLevel[i]);
        }
        artifact.setBlackLevel((blackLevel[0] + blackLevel[1] + blackLevel[2]) / 3);
        logger.finer(">>>> normalizationFactor: %f %f %f", normalizationFactor[0], normalizationFactor[1], normalizationFactor[2]);
        return normalizationFactor;
    }

    @Nonnull
    protected int[] getBlackLevel(@Nonnull PipelineArtifact artifact) {
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    }

    protected double getWhiteLevel(@Nonnull PipelineArtifact artifact) {
        logger.fine("getWhiteLevel(%s)", artifact);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD rasterIFD = metadata.getRasterIFD();
        int bitsPerSample = rasterIFD.getBitsPerSample()[0];
        double whiteLevel = (1 << bitsPerSample) - 1;
        logger.finer(">>>> whiteLevel from bitsPerSample: %f", whiteLevel);
        return whiteLevel;
    }

    protected static double getMeanValue(@Nonnull TagRational[] black) {
        double v = 0.0;
        for (int i = 0; i < black.length; ++i) {
            v += black[i].doubleValue();
        }
        return v / (double)black.length;
    }
}

