/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.pef;

import it.tidalwave.imageio.pef.PentaxMakerNote;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;

public class PEFWhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = PEFWhiteBalanceOperation.getLogger(PEFWhiteBalanceOperation.class);

    public PEFWhiteBalanceOperation() {
        super(Source.Type.RAW);
    }

    public void process(PipelineArtifact artifact) {
        logger.fine("process()", new Object[0]);
        PentaxMakerNote pefMakernote = (PentaxMakerNote)artifact.getRAWMetadata().getMakerNote();
        int[] coefficients = pefMakernote.getWhiteBalanceInfo();
        double scale = 1.220703125E-4;
        artifact.multiplyRedCoefficient(scale * (double)coefficients[0]);
        artifact.multiplyGreenCoefficient(scale * (double)coefficients[1]);
        artifact.multiplyBlueCoefficient(scale * (double)coefficients[3]);
    }
}

