/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NEFWhiteBalanceInfo;
import it.tidalwave.imageio.nef.Nikon3MakerNoteSupport;
import it.tidalwave.imageio.nef.NikonCaptureEditorMetadata;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;

public class NEFWhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = NEFWhiteBalanceOperation.getLogger(NEFWhiteBalanceOperation.class);

    public NEFWhiteBalanceOperation() {
        super(Source.Type.RAW);
    }

    public void process(PipelineArtifact artifact) {
        logger.fine("process()", new Object[0]);
        NEFMetadata metadata = (NEFMetadata)artifact.getRAWMetadata();
        NikonMakerNote3 makerNote = metadata.getNikonMakerNote();
        NikonCaptureEditorMetadata nceMetadata = (NikonCaptureEditorMetadata)metadata.getCaptureEditorMetadata();
        if (this.isNCESettingAvailable(nceMetadata)) {
            this.applyNCESettings(artifact, nceMetadata);
        } else {
            this.applyCameraSettings(artifact, makerNote);
        }
    }

    private void applyCameraSettings(PipelineArtifact artifact, NikonMakerNote3 makerNote) {
        Nikon3MakerNoteSupport.WhiteBalance cameraWhiteBalance = makerNote.getWhiteBalance();
        TagRational[] whiteBalanceCoefficients = makerNote.getWhiteBalanceRBCoefficients();
        NEFWhiteBalanceInfo whiteBalanceInfo = makerNote.getWhiteBalanceInfo();
        if (whiteBalanceInfo != null && whiteBalanceInfo.isValid()) {
            int[] coefficients = whiteBalanceInfo.getCoefficients();
            logger.finer(">>>> NEFWhiteBalanceInfo: %s %s v%s %s %s %s %s", cameraWhiteBalance, artifact.getCFAPatternAsString(), Integer.toHexString(whiteBalanceInfo.getVersion()), coefficients[0], coefficients[1], coefficients[2], coefficients[3]);
            artifact.multiplyRedCoefficient(whiteBalanceInfo.getRedCoefficient());
            artifact.multiplyGreenCoefficient(whiteBalanceInfo.getGreen1Coefficient());
            artifact.multiplyBlueCoefficient(whiteBalanceInfo.getBlueCoefficient());
        } else if (whiteBalanceCoefficients != null) {
            logger.finer(">>>> using WhiteBalanceRB coefficients: %s", cameraWhiteBalance);
            artifact.multiplyRedCoefficient(whiteBalanceCoefficients[0].doubleValue());
            artifact.multiplyBlueCoefficient(whiteBalanceCoefficients[1].doubleValue());
        }
    }

    private boolean isNCESettingAvailable(NikonCaptureEditorMetadata nceMetadata) {
        return nceMetadata != null && nceMetadata.isWhiteBalanceEnabled() && (nceMetadata.getWhiteBalanceTemperature() != 0 || nceMetadata.getWhiteBalanceWhitePoint() == 1);
    }

    private void applyNCESettings(PipelineArtifact artifact, NikonCaptureEditorMetadata nceMetadata) {
        logger.finer(">>>> using NCE coefficients", new Object[0]);
        artifact.multiplyRedCoefficient(nceMetadata.getWhiteBalanceRedCoeff());
        artifact.multiplyBlueCoefficient(nceMetadata.getWhiteBalanceBlueCoeff());
    }
}

