/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NikonCaptureEditorMetadata;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.ExposureOperation;
import it.tidalwave.imageio.util.Logger;

public class NEFExposureOperation
extends ExposureOperation {
    private static final String CLASS = "it.tidalwave.imageio.rawprocessor.nef.NEFExposureOperation";
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.rawprocessor.nef.NEFExposureOperation");

    public void process(PipelineArtifact artifact) {
        logger.fine("process()", new Object[0]);
        NEFMetadata metadata = (NEFMetadata)artifact.getRAWMetadata();
        NikonCaptureEditorMetadata nceMetadata = (NikonCaptureEditorMetadata)metadata.getCaptureEditorMetadata();
        if (nceMetadata != null && nceMetadata.isAdvancedRawEnabled()) {
            double exposureCompensation = (double)nceMetadata.getEVCompensation() / 100.0;
            logger.finer(">>>> NCE exposure compensation: %s", exposureCompensation);
            double coefficient = Math.pow(2.0, exposureCompensation);
            artifact.multiplyRedCoefficient(coefficient);
            artifact.multiplyGreenCoefficient(coefficient);
            artifact.multiplyBlueCoefficient(coefficient);
        }
    }
}

