/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.mrw;

import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.mrw.MRWMetadata;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;

public class MRWSizeOperation
extends SizeOperation {
    private static final Logger logger = MRWSizeOperation.getLogger(MRWSizeOperation.class);

    @Nonnull
    protected Insets getCrop(@Nonnull PipelineArtifact artifact) {
        MRWMetadata metadata = (MRWMetadata)artifact.getRAWMetadata();
        MinoltaRawData.PRD prd = metadata.getMinoltaRawData().getPRD();
        BufferedImage bufferedImage = artifact.getImage();
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        Dimension newSize = prd.getImageSize();
        Insets crop = new Insets((height - newSize.height) / 2, (width - newSize.width) / 2, (height - newSize.height) / 2, (width - newSize.width) / 2);
        logger.finer(">>>> returning %s", crop);
        return crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull PipelineArtifact artifact) {
        logger.fine("getSize(%s)", artifact);
        MRWMetadata metadata = (MRWMetadata)artifact.getRAWMetadata();
        MinoltaRawData.PRD prd = metadata.getMinoltaRawData().getPRD();
        Dimension size = prd.getImageSize();
        logger.finer(">>>> returning %s", size);
        return size;
    }
}

