/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raf;

import it.tidalwave.imageio.raf.FujiMakerNote;
import it.tidalwave.imageio.raf.FujiRawData;
import it.tidalwave.imageio.raf.FujiTable1;
import it.tidalwave.imageio.raf.RAFHeaderProcessor;
import it.tidalwave.imageio.raf.RAFMetadata;
import it.tidalwave.imageio.raf.RAFRasterReader;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.spi.ImageReaderSpi;

public class RAFImageReader
extends TIFFImageReaderSupport {
    private static final String CLASS = RAFImageReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected RAFImageReader(@Nonnull ImageReaderSpi originatingProvider, @CheckForNull Object extension) {
        super(originatingProvider, FujiMakerNote.class, RAFMetadata.class);
        this.headerProcessor = new RAFHeaderProcessor();
    }

    @Nonnull
    protected Directory loadPrimaryDirectory() throws IOException {
        logger.fine("loadPrimaryDirectory() - %s", this.iis);
        this.headerProcessor.process(this.iis);
        this.iis.setBaseOffset(this.headerProcessor.getBaseOffset());
        this.iis.seek(this.headerProcessor.getOffset());
        long directoryOffset = RAFImageReader.processHeader(this.iis, this.headerProcessor);
        IFD primaryIFD = new IFD();
        primaryIFD.loadAll(this.iis, directoryOffset);
        return primaryIFD;
    }

    @Nonnull
    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        RAFRasterReader rasterReader = new RAFRasterReader();
        this.initializeRasterReader(rasterReader);
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec.", System.currentTimeMillis() - time);
        return raster;
    }

    protected void initializeRasterReader(@Nonnull RasterReader rasterReader) {
        FujiRawData fujiRawData = ((RAFHeaderProcessor)this.headerProcessor).getFujiRawData();
        FujiTable1 fujiTable1 = fujiRawData.getFujiTable1();
        boolean fujiLayout = fujiTable1.isFujiLayout();
        rasterReader.setWidth(fujiTable1.getRotatedWidth());
        rasterReader.setHeight(fujiTable1.getRotatedHeight());
        int topMargin = (fujiTable1.getRawHeight() - fujiTable1.getHeight()) / 2;
        int leftMargin = (fujiTable1.getRawWidth() - fujiTable1.getWidth()) / 2;
        ((RAFRasterReader)rasterReader).setCFAWidth(fujiTable1.getRawWidth());
        ((RAFRasterReader)rasterReader).setCFAHeight(fujiTable1.getRawHeight());
        ((RAFRasterReader)rasterReader).setFujiLayout(fujiLayout);
        ((RAFRasterReader)rasterReader).setOffset(fujiTable1.getWidth() / (fujiLayout ? 1 : 2));
        ((RAFRasterReader)rasterReader).setTopMargin(topMargin);
        ((RAFRasterReader)rasterReader).setLeftMargin(leftMargin);
        rasterReader.setBitsPerSample(12);
        IFD exif = ((RAFMetadata)this.metadata).getExifIFD();
        rasterReader.setRasterOffset(fujiRawData.getCFAOffset());
        rasterReader.setStripByteCount(fujiRawData.getCFALength());
        rasterReader.setCFAPattern(new byte[]{1, 2, 0, 1});
        rasterReader.setCompression(0);
    }
}

