/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.pef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.pef.PEFImageReader;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.imageio.ImageReader;

public class PEFImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = PEFImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public PEFImageReaderSpi() {
        super("PEF", "pef", "image/x-pentax-pef", PEFImageReader.class);
    }

    @Nonnull
    public String getDescription(Locale locale) {
        return "Standard PEF Image Reader";
    }

    @Nonnull
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new PEFImageReader(this, extension);
    }

    public boolean canDecodeInput(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.seek(0L);
        long ifdOffset = TIFFImageReaderSupport.processHeader(iis, null);
        IFD primaryIFD = new IFD();
        primaryIFD.load(iis, ifdOffset);
        if (primaryIFD.isDNGVersionAvailable()) {
            return false;
        }
        String make = primaryIFD.getMake();
        String model = primaryIFD.getModel();
        if (make == null || !make.toUpperCase().startsWith("PENTAX")) {
            logger.fine("PEFImageReaderSpi giving up on: '%s' / '%s'", make, model);
            return false;
        }
        return true;
    }
}

