/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.orf.CameraSettings;
import it.tidalwave.imageio.orf.Equipment;
import it.tidalwave.imageio.orf.FocusInfo;
import it.tidalwave.imageio.orf.ImageProcessing;
import it.tidalwave.imageio.orf.OlympusMakerNoteSupport;
import it.tidalwave.imageio.orf.RawDevelopment;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.tiff.TIFFTag;
import it.tidalwave.imageio.tiff.ThumbnailLoader;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class OlympusMakerNote
extends OlympusMakerNoteSupport {
    private static final String CLASS = OlympusMakerNote.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = 6357805620960118907L;
    private Equipment equipment;
    private CameraSettings cameraSettings;
    private RawDevelopment rawDevelopment;
    private ImageProcessing imageProcessing;
    private FocusInfo focusInfo;
    private boolean offsetCorrection = false;

    public void loadAll(@Nonnull RAWImageInputStream iis, long offset) throws IOException {
        logger.fine("loadAll(%s, %d)", iis, offset);
        long baseOffsetSave = iis.getBaseOffset();
        iis.seek(offset);
        byte[] buffer = new byte[8];
        iis.readFully(buffer);
        String s = new String(buffer, 0, 5);
        if (s.equals("OLYMP")) {
            long savePosition = iis.getStreamPosition();
            int tag = iis.readInt();
            if (tag != 215369) {
                this.offsetCorrection = true;
                iis.seek(savePosition);
            }
            logger.finer(">>>> tag: %08x, savePosition: %d", tag, savePosition);
            super.load(iis, iis.getStreamPosition());
            this.loadCameraSettings(iis);
        }
        iis.setBaseOffset(baseOffsetSave);
    }

    @CheckForNull
    public CameraSettings getOlympusCameraSettings() {
        return this.cameraSettings;
    }

    @CheckForNull
    public Equipment getOlympusEquipment() {
        return this.equipment;
    }

    @CheckForNull
    public FocusInfo getOlympusFocusInfo() {
        return this.focusInfo;
    }

    @CheckForNull
    public ImageProcessing getOlympusImageProcessing() {
        return this.imageProcessing;
    }

    @CheckForNull
    public RawDevelopment getOlympusRawDevelopment() {
        return this.rawDevelopment;
    }

    @Nonnull
    protected ThumbnailLoader loadThumbnailHelper(@Nonnull RAWImageInputStream iis) throws IOException, NoSuchElementException {
        if (this.cameraSettings != null && this.cameraSettings.isThumbnailOffsetAvailable() && this.cameraSettings.isThumbnailSizeAvailable()) {
            int makerNoteOffset;
            int offset = makerNoteOffset = (int)this.getStart() - 12;
            if (this.offsetCorrection) {
                offset -= 784;
            }
            int thumbnailOffset = this.cameraSettings.getThumbnailOffset() + offset;
            int thumbnailSize = this.cameraSettings.getThumbnailSize();
            return new ThumbnailLoader(iis, thumbnailOffset, thumbnailSize);
        }
        throw new NoSuchElementException();
    }

    private void loadMakerNoteIFD(@Nonnull RAWImageInputStream iis, @Nonnull Directory directory, @Nonnull Object key, @Nonnull String string) throws IOException {
        Object value = this.getObject(key);
        if (value instanceof byte[]) {
            TIFFTag tag = (TIFFTag)this.getTag(key);
            directory.load(iis, tag.getValueOffset());
        } else {
            int makerNoteOffset = (int)this.getStart() - 12;
            directory.load(iis, makerNoteOffset + (Integer)value);
        }
        logger.fine("%s: %s", string, directory);
    }

    private void loadCameraSettings(@Nonnull RAWImageInputStream iis) throws IOException {
        if (this.isEquipmentAvailable()) {
            this.equipment = new Equipment();
            this.loadMakerNoteIFD(iis, this.equipment, EQUIPMENT, "Equipment");
        }
        if (this.isCameraSettingsAvailable()) {
            this.cameraSettings = new CameraSettings();
            this.loadMakerNoteIFD(iis, this.cameraSettings, CAMERASETTINGS, "CameraSettings");
        }
        if (this.isRawDevelopmentAvailable()) {
            this.rawDevelopment = new RawDevelopment();
            this.loadMakerNoteIFD(iis, this.rawDevelopment, RAWDEVELOPMENT, "RawDevelopment");
        }
        if (this.isImageProcessingAvailable()) {
            this.imageProcessing = new ImageProcessing();
            this.loadMakerNoteIFD(iis, this.imageProcessing, IMAGEPROCESSING, "ImageProcessing");
        }
        if (this.isFocusInfoAvailable()) {
            this.focusInfo = new FocusInfo();
            this.loadMakerNoteIFD(iis, this.focusInfo, FOCUSINFO, "FocusInfo");
        }
    }
}

