/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.mrw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import javax.annotation.Nonnull;

public class MRWHeaderProcessor
extends HeaderProcessor {
    private static final String CLASS = MRWHeaderProcessor.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private final MinoltaRawData minoltaRawData = new MinoltaRawData();

    public void process(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.setBaseOffset(0L);
        iis.seek(4L);
        this.minoltaRawData.load(iis, 8, iis.getByteOrder());
    }

    public int getBaseOffset() {
        return this.minoltaRawData.getBaseOffset();
    }

    @Nonnull
    public MinoltaRawData getMinoltaRawData() {
        return this.minoltaRawData;
    }
}

