/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.cr2;

import it.tidalwave.imageio.cr2.CR2Metadata;
import it.tidalwave.imageio.cr2.CR2RasterReader;
import it.tidalwave.imageio.cr2.CR2SensorInfo;
import it.tidalwave.imageio.cr2.CanonCR2MakerNote;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;

public class CR2ImageReader
extends TIFFImageReaderSupport {
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.crw.CR2ImageReader");

    protected CR2ImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider, CanonCR2MakerNote.class, CR2Metadata.class);
    }

    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        CR2RasterReader rasterReader = new CR2RasterReader();
        IFD rasterIFD = ((CR2Metadata)this.metadata).getRasterIFD();
        CanonCR2MakerNote cr2MakerNote = (CanonCR2MakerNote)this.makerNote;
        CR2SensorInfo sensorInfo = cr2MakerNote.getSensorInfo();
        rasterReader.setWidth(sensorInfo.getWidth());
        rasterReader.setHeight(sensorInfo.getHeight());
        rasterReader.setBitsPerSample(12);
        rasterReader.setCFAPattern(new byte[]{0, 1, 1, 2});
        this.iis.seek(rasterIFD.getStripOffsets());
        rasterReader.setStripByteCount(rasterIFD.getStripByteCounts());
        rasterReader.setCompression(rasterIFD.getCompression().intValue());
        if (rasterIFD.isCanonTileInfoAvailable()) {
            int[] tileInfo = rasterIFD.getCanonTileInfo();
            rasterReader.setCanonTileWidth(tileInfo[1]);
            rasterReader.setCanonLastTileWidth(tileInfo[2]);
        }
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec", System.currentTimeMillis() - time);
        return raster;
    }
}

