/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.ui;

import java.io.File;
import org.stamppagetor.UiPlatform;
import org.stamppagetor.preferences.LatestFiles;
import org.stamppagetor.ui.RuleLatestFileNameAvailable;
import org.stamppagetor.ui.RuleStatic;
import org.stamppagetor.ui.UiBundle;
import org.stamppagetor.ui.UiItemMenu;

public class UiBundleLatestFiles
extends UiBundle {
    private final int index;
    private final LatestFiles files = LatestFiles.getInstance();
    private final UiItemMenu menu;

    public UiBundleLatestFiles(int n) {
        super("LOAD_LATEST_FILE" + n, RuleStatic.TRUE, new RuleLatestFileNameAvailable(n), RuleStatic.FALSE);
        this.index = n;
        File file = this.files.getLatestFile(this.index);
        String string = file == null ? "<none>" : file.getName();
        this.menu = new UiItemMenu(4000 + n, "Album", string);
        this.addUiItem(this.menu);
    }

    @Override
    public void checkStatesOfUiComponents(UiPlatform uiPlatform) {
        super.checkStatesOfUiComponents(uiPlatform);
        File file = this.files.getLatestFile(this.index);
        if (file != null) {
            this.menu.setText(file.getName());
        }
    }

    @Override
    public void doAction(UiPlatform uiPlatform) {
        File file = this.files.getLatestFile(this.index);
        if (file != null) {
            uiPlatform.loadFile(file);
        }
    }
}

