/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.ui;

import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.stamppagetor.UiPlatform;
import org.stamppagetor.ui.RuleStatic;
import org.stamppagetor.ui.UiItem;
import org.stamppagetor.ui.UiStateRule;

public abstract class UiBundle {
    protected final Vector<UiItem> uiItems = new Vector();
    private final String command;
    private final UiStateRule enableRule;
    private final UiStateRule visibleRule;
    private final UiStateRule checkedRule;
    private final Vector<KeyStroke> globalKeyboardActions = new Vector();

    public UiBundle(String string) {
        this(string, RuleStatic.TRUE);
    }

    public UiBundle(String string, UiStateRule uiStateRule) {
        this(string, uiStateRule, RuleStatic.TRUE, RuleStatic.FALSE);
    }

    public UiBundle(String string, UiStateRule uiStateRule, UiStateRule uiStateRule2, UiStateRule uiStateRule3) {
        this.command = string;
        this.enableRule = uiStateRule;
        this.visibleRule = uiStateRule2;
        this.checkedRule = uiStateRule3;
    }

    public boolean isUndoable() {
        return true;
    }

    protected void addGlobalKeyboardAction(KeyStroke keyStroke) {
        this.globalKeyboardActions.add(keyStroke);
    }

    protected void addUiItem(UiItem uiItem) {
        this.uiItems.add(uiItem);
        uiItem.setBundle(this);
    }

    public String getCommand() {
        return this.command;
    }

    public void addUiComponents(UiPlatform uiPlatform) {
        for (UiItem uiItem : this.uiItems) {
            uiItem.addUiComponent(uiPlatform);
        }
    }

    public void addKeyboardStuff(UiPlatform uiPlatform) {
        InputMap inputMap = uiPlatform.getTreePane().getInputMap(0);
        for (UiItem object : this.uiItems) {
            KeyStroke keyStroke = object.getKeySroke();
            if (keyStroke == null) continue;
            inputMap.put(keyStroke, "none");
        }
        for (KeyStroke keyStroke : this.globalKeyboardActions) {
            uiPlatform.getTreePane().registerKeyboardAction(uiPlatform.getActionListener(), this.command, keyStroke, 0);
        }
    }

    public void checkStatesOfUiComponents(UiPlatform uiPlatform) {
        this.setEnableToAll(this.enableRule.state(uiPlatform));
        this.setVisibleToAll(this.visibleRule.state(uiPlatform));
        this.setCheckedToAll(this.checkedRule.state(uiPlatform));
    }

    public abstract void doAction(UiPlatform var1);

    private void setEnableToAll(boolean bl) {
        for (UiItem uiItem : this.uiItems) {
            uiItem.setEnabled(bl);
        }
    }

    private void setVisibleToAll(boolean bl) {
        for (UiItem uiItem : this.uiItems) {
            uiItem.setVisible(bl);
        }
    }

    private void setCheckedToAll(boolean bl) {
        for (UiItem uiItem : this.uiItems) {
            uiItem.setChecked(bl);
        }
    }

    public Vector<UiItem> getUiItems() {
        return this.uiItems;
    }
}

