/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.ui;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.stamppagetor.StampPlace;
import org.stamppagetor.ui.OptionsDialog;

class StampPlaceOptionsDialog
extends OptionsDialog {
    private static final long serialVersionUID = -5414008343883616938L;
    private final StampPlace place;
    private JTextField text1 = new JTextField(16);
    private JTextField text2 = new JTextField(16);
    private JTextField text3 = new JTextField(16);
    private JTextField sizeX = new JTextField(6);
    private JTextField sizeY = new JTextField(6);

    public StampPlaceOptionsDialog(StampPlace stampPlace, JFrame jFrame) {
        super(jFrame, "Stamp options");
        this.place = stampPlace;
        this.updateData(false);
    }

    @Override
    protected JPanel createOptionsPane() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.add(new JLabel("text1:"));
        jPanel2.add(new JLabel("text2:"));
        jPanel3.add(new JLabel("text3:"));
        jPanel.add(this.text1);
        jPanel2.add(this.text2);
        jPanel3.add(this.text3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Texts"));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        jPanel5.add(new JLabel("width:"));
        jPanel6.add(new JLabel("height:"));
        jPanel5.add(this.sizeX);
        jPanel6.add(this.sizeY);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 3));
        jPanel7.setBorder(BorderFactory.createTitledBorder("Size"));
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 3));
        jPanel8.add(jPanel7);
        jPanel8.add(jPanel4);
        return jPanel8;
    }

    @Override
    protected boolean updateData(boolean bl) {
        if (bl) {
            try {
                int n = Integer.parseInt(this.sizeX.getText());
                int n2 = Integer.parseInt(this.sizeY.getText());
                if (n <= 0 || n2 <= 0 || n > 180 || n2 > 280) {
                    throw new Exception("Invalid size ");
                }
                this.place.setSize(new Dimension(n, n2));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.ownerFrame, "Given size is invalid", "Error", 0);
                return false;
            }
            this.place.setText(0, this.text1.getText());
            this.place.setText(1, this.text2.getText());
            this.place.setText(2, this.text3.getText());
        } else {
            Dimension dimension = this.place.getSize();
            this.sizeX.setText(Integer.toString(dimension.width));
            this.sizeY.setText(Integer.toString(dimension.height));
            this.text1.setText(this.place.getText(0));
            this.text2.setText(this.place.getText(1));
            this.text3.setText(this.place.getText(2));
        }
        return true;
    }
}

