/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.property;

import java.util.Vector;
import org.stamppagetor.property.PropertiesInterface;
import org.stamppagetor.property.PropertyInfo;
import org.stamppagetor.property.PropertyListener;

public class PropertyTableModel {
    private PropertiesInterface data = null;
    private Vector<PropertyListener> listeners = new Vector();

    public PropertyTableModel(PropertyListener propertyListener, PropertiesInterface propertiesInterface) {
        this.listeners.add(propertyListener);
        this.data = propertiesInterface;
    }

    private void firePropertyChange(int n, boolean bl) {
        for (PropertyListener propertyListener : this.listeners) {
            propertyListener.propertyValueChanged(this.data, n, bl);
        }
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPropertyCount();
    }

    public String getName(int n) {
        return this.data.getPropertyInfo(n).getName();
    }

    public Object getValueAt(int n) {
        Object object = null;
        object = this.data.getPropertyValue(n);
        if (object == null) {
            object = "";
        }
        return object;
    }

    public PropertyInfo getInfo(int n) {
        return this.data.getPropertyInfo(n);
    }

    public void setValueAt(Object object, int n) {
        if (this.data == null) {
            return;
        }
        Object object2 = this.data.getPropertyValue(n);
        if (object2 == null || !object2.equals(object)) {
            this.firePropertyChange(n, false);
            this.data.setPropertyValue(n, object);
            this.firePropertyChange(n, true);
        }
    }
}

