/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.property;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import org.stamppagetor.property.PropertyCell;
import org.stamppagetor.property.PropertyTableModel;

public class PropertyPanel
extends JPanel {
    private static final long serialVersionUID = -4410461987449405093L;
    private PropertyTableModel tableModel = null;
    private JPanel tablePanel = new JPanel();
    private final JPanel fillerPanel = new JPanel();
    private PropertyCell[] cells = null;
    private JLabel[] labels = null;
    private SpringLayout layout = new SpringLayout();

    public PropertyPanel() {
        super(new BorderLayout());
        this.add((Component)this.fillerPanel, "Center");
        this.add((Component)this.tablePanel, "North");
        this.tablePanel.setLayout(this.layout);
    }

    public void setModel(PropertyTableModel propertyTableModel) {
        this.tableModel = propertyTableModel;
        this.remove(this.tablePanel);
        this.tablePanel.removeAll();
        this.tablePanel = new JPanel();
        this.add((Component)this.tablePanel, "North");
        this.layout = new SpringLayout();
        this.tablePanel.setLayout(this.layout);
        int n = this.tableModel.getRowCount();
        this.cells = new PropertyCell[n];
        this.labels = new JLabel[n];
        for (int i = 0; i < n; ++i) {
            this.labels[i] = new JLabel(this.tableModel.getName(i) + ": ", 4);
            this.tablePanel.add(this.labels[i]);
            this.cells[i] = this.tableModel.getInfo(i).createPropertyCell(this.tableModel, i);
            this.tablePanel.add(this.cells[i].getControl());
        }
        Spring spring = Spring.constant(5);
        Spring spring2 = Spring.constant(5);
        for (int i = 0; i < n; ++i) {
            spring = Spring.max(spring, this.layout.getConstraints(this.labels[i]).getWidth());
            spring2 = Spring.max(spring2, this.layout.getConstraints(this.cells[i].getControl()).getWidth());
        }
        Spring spring3 = Spring.constant(5);
        Spring spring4 = Spring.sum(spring, Spring.constant(10));
        Spring spring5 = Spring.constant(5);
        for (int i = 0; i < n; ++i) {
            SpringLayout.Constraints constraints = this.layout.getConstraints(this.labels[i]);
            SpringLayout.Constraints constraints2 = this.layout.getConstraints(this.cells[i].getControl());
            constraints.setX(spring3);
            constraints2.setX(spring4);
            constraints2.setWidth(spring2);
            constraints.setY(spring5);
            constraints2.setY(spring5);
            Spring spring6 = Spring.max(constraints.getHeight(), constraints2.getHeight());
            constraints.setHeight(spring6);
            constraints2.setHeight(spring6);
            spring5 = Spring.sum(spring5, Spring.sum(spring6, Spring.constant(5)));
        }
        spring4 = Spring.sum(spring4, Spring.sum(spring2, Spring.constant(5)));
        SpringLayout.Constraints constraints = this.layout.getConstraints(this.tablePanel);
        constraints.setConstraint("South", spring5);
        constraints.setConstraint("East", spring4);
        this.dataChanged();
    }

    public void dataChanged() {
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.cells[i].updateValue();
        }
        this.validate();
    }
}

