/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.property;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.stamppagetor.property.PropertyTableModel;

public abstract class PropertyCell
implements FocusListener,
ActionListener {
    private static final Border valueBorder = BorderFactory.createEtchedBorder(1);
    protected final PropertyTableModel tableModel;
    protected final int tableIndex;

    public PropertyCell(PropertyTableModel propertyTableModel, int n) {
        this.tableModel = propertyTableModel;
        this.tableIndex = n;
    }

    protected void setCellStyle(JComponent jComponent) {
        jComponent.setBorder(valueBorder);
        jComponent.addFocusListener(this);
    }

    public void updateValue() {
        this.setValue(this.tableModel.getValueAt(this.tableIndex));
    }

    public abstract void storeValue();

    public abstract JComponent getControl();

    protected abstract void setValue(Object var1);

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.storeValue();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.storeValue();
    }
}

