/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.preferences;

import java.io.File;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class LatestFiles {
    private static final String PREF_FILENAME = "filename";
    private static final int MAX_STORED_NAMES_COUNT = 8;
    private static LatestFiles theInstance = null;
    private Vector<File> files = new Vector();
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());

    private LatestFiles() {
        for (int i = 0; i < 8; ++i) {
            String string = this.prefs.get(PREF_FILENAME + (8 - i), null);
            if (string == null) continue;
            this.files.add(new File(string));
        }
    }

    public static synchronized LatestFiles getInstance() {
        if (theInstance == null) {
            theInstance = new LatestFiles();
        }
        return theInstance;
    }

    public File[] getLatestFiles(int n) {
        int n2 = this.files.size();
        int n3 = Math.min(n, n2);
        File[] fileArray = new File[n3];
        for (int i = 0; i < n3; ++i) {
            fileArray[i] = this.files.elementAt(n2 - 1 - i);
        }
        return fileArray;
    }

    public File getLatestFile(int n) {
        int n2 = this.files.size();
        if (n < 0) {
            return null;
        }
        if (n >= n2) {
            return null;
        }
        return this.files.elementAt(n2 - 1 - n);
    }

    public void addFile(String string) {
        this.addFile(new File(string));
    }

    public void addFile(File file) {
        for (int i = 0; i < this.files.size(); ++i) {
            if (!this.files.elementAt(i).equals(file)) continue;
            this.files.remove(i);
            break;
        }
        this.files.add(file);
    }

    public void storeList() {
        int n = this.files.size();
        int n2 = Math.min(8, n);
        try {
            for (int i = 0; i < n2; ++i) {
                File file = this.files.elementAt(n - 1 - i);
                this.prefs.put(PREF_FILENAME + (i + 1), file.getAbsolutePath());
            }
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.err.println("Can not store list of recent files");
            System.err.println(backingStoreException.toString());
        }
    }
}

