/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.image;

import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;

public class ImageArea {
    private Vector<Point> points = new Vector();

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public Point getPoint(int n) {
        return this.points.elementAt(n);
    }

    public int getSize() {
        return this.points.size();
    }

    public Polygon createPolygon(double d) {
        Polygon polygon = new Polygon();
        for (Point point : this.points) {
            polygon.addPoint((int)((double)point.x * d), (int)((double)point.y * d));
        }
        return polygon;
    }

    public void increaseArea(int n) {
        Point point = this.getMiddlePoint();
        for (Point point2 : this.points) {
            int n2 = point2.x - point.x;
            int n3 = point2.y - point.y;
            point2.x += n2 * n / 100;
            point2.y += n3 * n / 100;
        }
    }

    public Point getMiddlePoint() {
        int n = 0;
        int n2 = 0;
        int n3 = this.points.size();
        for (Point point : this.points) {
            n += point.x;
            n2 += point.y;
        }
        return new Point(n / n3, n2 / n3);
    }

    public int findIndexOfLongestLine() {
        double d = -1.0;
        int n = 0;
        int n2 = this.points.size();
        for (int i = 0; i < n2; ++i) {
            Point point;
            Point point2 = this.points.elementAt(i % n2);
            double d2 = point2.distance(point = this.points.elementAt((i + 1) % n2));
            if (!(d2 >= d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public int joinPoints() {
        int n = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            if (!this.joinPoints(i)) continue;
            ++n;
        }
        return n;
    }

    private boolean joinPoints(int n) {
        int n2 = this.points.size();
        if (n2 < 4) {
            return false;
        }
        int n3 = (n + 0) % n2;
        int n4 = (n + 1) % n2;
        int n5 = (n + 2) % n2;
        int n6 = (n + 3) % n2;
        Point point = this.points.elementAt(n3);
        Point point2 = this.points.elementAt(n4);
        Point point3 = this.points.elementAt(n5);
        Point point4 = this.points.elementAt(n6);
        int n7 = Math.abs(point.x - point2.x) + Math.abs(point.y - point2.y);
        int n8 = Math.abs(point3.x - point4.x) + Math.abs(point3.y - point4.y);
        int n9 = Math.abs(point3.x - point2.x) + Math.abs(point3.y - point2.y);
        if (n9 > (n7 + n8) / 12 && n9 > 10) {
            return false;
        }
        double d = point.getX();
        double d2 = point2.getX();
        double d3 = point3.getX();
        double d4 = point4.getX();
        double d5 = point.getY();
        double d6 = point2.getY();
        double d7 = point3.getY();
        double d8 = point4.getY();
        double d9 = d2 - d;
        double d10 = d4 - d3;
        if (d9 == 0.0) {
            d9 = 0.01;
        }
        if (d10 == 0.0) {
            d10 = 0.01;
        }
        double d11 = (d6 - d5) / d9;
        double d12 = (d8 - d7) / d10;
        double d13 = d5 - d * d11;
        double d14 = d7 - d3 * d12;
        if (d11 == d12) {
            if (point2.distance(point3) < 3.0) {
                if (n5 > n4) {
                    this.points.remove(n5);
                    this.points.remove(n4);
                } else {
                    this.points.remove(n4);
                    this.points.remove(n5);
                }
                return true;
            }
            return false;
        }
        double d15 = (d14 - d13) / (d11 - d12);
        double d16 = d11 * d15 + d13;
        Point point5 = new Point((int)d15, (int)d16);
        if (point5.distance(point2) > 20.0 && point5.distance(point3) > 20.0) {
            return false;
        }
        if (n5 > n4) {
            this.points.remove(n5);
            point2.x = (int)d15;
            point2.y = (int)d16;
        } else {
            this.points.remove(n4);
            point3.x = (int)d15;
            point3.y = (int)d16;
        }
        return true;
    }

    public int removeInnerCorners() {
        int n = 0;
        int n2 = 0;
        while (n < this.points.size()) {
            if (!this.removeInnerCorners(n)) {
                ++n;
                continue;
            }
            ++n2;
            ++n;
        }
        return n2;
    }

    private boolean removeInnerCorners(int n) {
        double d;
        int n2 = this.points.size();
        if (n2 < 4) {
            return false;
        }
        int n3 = (n + 0) % n2;
        int n4 = (n + 1) % n2;
        int n5 = (n + 2) % n2;
        Point point = this.points.elementAt(n3);
        Point point2 = this.points.elementAt(n4);
        Point point3 = this.points.elementAt(n5);
        double d2 = ImageArea.angle(point, point2);
        double d3 = (360.0 + d2 - (d = ImageArea.angle(point, point3))) % 360.0;
        if (d3 >= 180.0) {
            d3 -= 360.0;
        }
        if (d3 <= 0.0 || d3 > 160.0 || d < -500.0 || d2 < -500.0) {
            this.points.remove(n4);
            return true;
        }
        return false;
    }

    public void simplifyLines() {
        int n = 0;
        while (n < this.points.size()) {
            if (this.simplifyLines(n)) continue;
            ++n;
        }
    }

    private boolean simplifyLines(int n) {
        double d;
        double d2;
        int n2 = this.points.size();
        if (n2 < 4) {
            return false;
        }
        int n3 = (n + 0) % n2;
        int n4 = (n + 1) % n2;
        int n5 = (n + 2) % n2;
        Point point = this.points.elementAt(n3);
        Point point2 = this.points.elementAt(n4);
        Point point3 = this.points.elementAt(n5);
        double d3 = ImageArea.angle(point, point2);
        double d4 = (360.0 + d3 - (d2 = ImageArea.angle(point, point3))) % 360.0;
        if (d4 > 180.0) {
            d4 -= 360.0;
        }
        if (Math.abs(d = ImageArea.angleDiff(point, point2, point3)) < 15.0 || d4 <= 0.0 && d2 > -500.0) {
            this.points.remove(n4);
            return true;
        }
        return false;
    }

    private static double angleDiff(Point point, Point point2, Point point3) {
        double d;
        double d2 = ImageArea.angle(point, point2);
        if (d2 - (d = ImageArea.angle(point2, point3)) > 180.0) {
            d += 360.0;
        }
        if (d - d2 > 180.0) {
            d2 += 360.0;
        }
        return Math.abs(d2 - d);
    }

    private static double angle(Point point, Point point2) {
        double d = point2.getX() - point.getX();
        double d2 = -1.0 * (point2.getY() - point.getY());
        if (point.x == point2.x && point.y == point2.y) {
            return -1000.0;
        }
        double d3 = d2 >= 0.0 ? Math.acos(d / point2.distance(point)) : Math.PI * 2 - Math.acos(d / point2.distance(point));
        d3 = Math.toDegrees(d3);
        return d3;
    }
}

