/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintStream;
import org.stamppagetor.DocStyle;
import org.stamppagetor.StampLine;
import org.stamppagetor.StampPrintable;
import org.stamppagetor.StampTitle;
import org.stamppagetor.property.PropertyInfo;
import org.stamppagetor.property.PropertyInfoString;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StampGroup
extends StampPrintable {
    public static final String XML_NODE_NAME = "group";
    private static final int DEFAULT_TITLE_FONT_SIZE = 8;
    private static final int DEFAULT_TITLE_FONT_STYLE = 2;
    private StampTitle title;
    private static final PropertyInfo[] properties = new PropertyInfo[]{new PropertyInfoString("Group title", null)};

    public StampGroup() {
        this.title = new StampTitle("Title of group", 2, 8);
    }

    public StampGroup(String string) {
        this.title = new StampTitle(string, 2, 8);
    }

    public StampGroup(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().compareTo("text") == 0) {
                this.title = new StampTitle(node2, 2, 8);
            }
            if (node2.getNodeName().compareTo("line") != 0) continue;
            this.parts.add(new StampLine(node2));
        }
    }

    public StampGroup(StampGroup stampGroup) {
        super(stampGroup);
        this.title = new StampTitle(stampGroup.title);
    }

    @Override
    public StampPrintable deepCopy() {
        return new StampGroup(this);
    }

    @Override
    public void toXml(PrintStream printStream, String string) {
        string = string + "  ";
        printStream.println(string + "<group>");
        this.title.toXml(printStream, string);
        for (StampPrintable stampPrintable : this.parts) {
            stampPrintable.toXml(printStream, string);
        }
        printStream.println(string + "</group>");
    }

    @Override
    public void print(Graphics graphics, DocStyle docStyle, StampPrintable stampPrintable, Rectangle rectangle) {
        this.printRect(graphics, stampPrintable, rectangle);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, this.title.getHeight(docStyle));
        this.title.print(graphics, docStyle, stampPrintable, rectangle2);
        this.printParts(graphics, docStyle, stampPrintable, rectangle);
    }

    @Override
    protected Rectangle[] getPartPlaces(Rectangle rectangle, DocStyle docStyle) {
        int n = this.parts.size();
        Rectangle[] rectangleArray = new Rectangle[n];
        int n2 = this.title.getHeight(docStyle);
        for (int i = 0; i < n; ++i) {
            int n3 = this.parts.elementAt(i).getHeight(docStyle);
            rectangleArray[i] = new Rectangle(0, n2, rectangle.width - 1, n3);
            n2 += n3;
        }
        return rectangleArray;
    }

    @Override
    protected int getHeight(DocStyle docStyle) {
        int n = this.title.getHeight(docStyle);
        for (StampPrintable stampPrintable : this.parts) {
            n += stampPrintable.getHeight(docStyle);
        }
        return n;
    }

    @Override
    protected int getWidth(DocStyle docStyle) {
        int n = 0;
        for (StampPrintable stampPrintable : this.parts) {
            n = Math.max(stampPrintable.getWidth(docStyle), n);
        }
        return n;
    }

    @Override
    public int getPropertyCount() {
        return properties.length;
    }

    @Override
    public PropertyInfo getPropertyInfo(int n) {
        return properties[n];
    }

    @Override
    public Object getPropertyValue(int n) {
        switch (n) {
            case 0: {
                return this.title.getText();
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        switch (n) {
            case 0: {
                this.title.setText((String)object);
                break;
            }
        }
    }

    public String toString() {
        return "Group: " + this.getTitleString();
    }

    public String getTitleString() {
        return this.title.getText();
    }

    public void setTitleString(String string) {
        this.title.setText(string);
    }
}

