/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.stamppagetor.PageView;
import org.stamppagetor.PageViewActionListener;
import org.stamppagetor.StampDocument;

public class PageListView
extends JPanel {
    private static final long serialVersionUID = 1205884629038251913L;
    private int selectedPage = 0;
    private StampDocument document = null;
    private final int MAX_PAGE_COUNT = 1000;
    private PageView[] pages = new PageView[this.MAX_PAGE_COUNT];

    public PageListView() {
        super.setLayout(new BoxLayout(this, 3));
        for (int i = 0; i < this.MAX_PAGE_COUNT; ++i) {
            PageView pageView = new PageView();
            pageView.setPreferredSize(new Dimension(160, 220));
            pageView.setPage(i);
            this.add(pageView);
            this.pages[i] = pageView;
        }
    }

    public void addActionListener(PageViewActionListener pageViewActionListener) {
        for (int i = 0; i < this.MAX_PAGE_COUNT; ++i) {
            this.pages[i].addActionListener(pageViewActionListener);
        }
    }

    public void updatePages() {
        int n = this.document == null ? 0 : this.document.getNumberOfPages();
        for (int i = 0; i < this.pages.length; ++i) {
            PageView pageView = this.pages[i];
            if (i < n) {
                pageView.setDoc(this.document);
                pageView.setPage(i);
                pageView.setPageHighLight(this.selectedPage == i);
                pageView.setVisible(true);
            } else {
                pageView.setVisible(false);
            }
            pageView.repaint();
        }
        super.repaint();
    }

    public void setDoc(StampDocument stampDocument) {
        if (this.document != stampDocument) {
            this.document = stampDocument;
            this.selectedPage = -1;
            this.updatePages();
        }
    }

    public void setPage(int n) {
        this.selectedPage = n;
        this.updatePages();
    }
}

