package dks.src.utils.pictures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class CPicture {
	/**
	 * Resize an existing BufferedImage to the specified size. If the image have already the great size, clear the graphics
	 * @param image the BufferedImage to resize or clear
	 * @param width the width of the result image
	 * @param height the height of the result image
	 * @return the new BufferedImage instance with the specified size
	 */
	public static BufferedImage resizeAndClearImage(BufferedImage image, int width, int height) {
		if (image == null || image.getWidth() != width || image.getHeight() != height) {
			image = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		} else {
			final Graphics2D graphics = (Graphics2D) image.getGraphics();
			graphics.setBackground(new Color(0, 0, 0, 0));
			graphics.clearRect(0, 0, width, height);
			graphics.dispose();
		}
		return image;
	}
}
