package dks.src.utils.editor;

import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.util.LinkedList;
import java.util.List;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;

/**
 * This class implements an editor for the PropertySheetTable
 * <br>
 * date : 5 sept. 07
 * @author DarK Sidious
 */
public class CAbstractEditor extends PropertySheetPanel {

	private static final long serialVersionUID = -5676680592069457812L;

	protected transient List<PropertyChangeListener> _listeners;

	public CAbstractEditor() {
		_listeners = new LinkedList<PropertyChangeListener>();
	}

	/**
	 * @see java.awt.Container#addPropertyChangeListener(java.beans.PropertyChangeListener)
	 * @param listener the PropertyChangeListener to add
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		_listeners.add(listener);
	}

	//$ANALYSIS-IGNORE,codereview.java.threads.synchronizedmethod
	/**
	 * @see java.awt.Component#removePropertyChangeListener(java.beans.PropertyChangeListener)
	 * @param listener the PropertyChangeListener to remove
	 */
	public synchronized void removePropertyChangeListener(PropertyChangeListener listener){
	  _listeners.remove(listener);
	}


	/**
	 * @param displayName the title display for the property
	 * @param shortDescription the description of the property
	 * @param type the type of class of the property
	 * @param value the value of the property
	 * @param name the name of the property
	 * @return the PropertySheetTable property created
	 */
	@SuppressWarnings("unchecked")
	protected Property createProperty(String displayName, String shortDescription, Class type, Object value, String name) {
		final DefaultProperty property = new DefaultProperty();
		property.setDisplayName(displayName);
		property.setShortDescription(shortDescription);
		property.setType(type);
		property.setValue(value);
		property.setName(name);
		return property;
	}

	public String toString() {
		return "dks.src.utils.editor.CAbstractEditor[]";
	}

	protected Object readResolve() throws ObjectStreamException {
		_listeners = new LinkedList<PropertyChangeListener>();
		return this;
	}
}

