package dks.src.textureEditor;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.ObjectStreamException;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import typecontrol.controls.JdksColorChooser;
import typecontrol.controls.JdksFileChooser;

import com.l2fprod.common.propertysheet.PropertySheetPanel;

import dks.src.gradientEditor.JdksGradientEditor;

/**
 * This class implements a tabbedPane containing some PropertySheetTable for mofying a layer of a texture <br> date : 5 sept. 07
 * @author   DarK Sidious
 */
public class PanLayer extends JTabbedPane {

	private static final long serialVersionUID = -5911624694002163122L;

	protected static final String TAB_COLOR_TITLE = "Couleur";
	protected static final String TAB_GRADIENT_TITLE = "Dgrad";
	protected static final String TAB_IMAGE_TITLE = "Image";

	/**
	 * The name of the color tab
	 */
	public static final String TAB_COLOR_NAME = "colColor";
	protected static final String TAB_COLOR_CAPTION = "Couleur : ";
	protected static final String TAB_COLOR_INFO = "Veuillez slectionner la couleur de la texture.";

	/**
	 * The name of the picture tab
	 */
	public static final String TAB_IMAGE_NAME = "filImage";
	protected static final String TAB_IMAGE_CAPTION = "Image : ";
	protected static final String TAB_IMAGE_INFO = "Veuillez slectionner l'image de la texture.";

	/**
	 * The name of the gradient tab
	 */
	public static final String DKS_GRADIENT_NAME = "dksGradient";

	/**
	 * The index of the color tab
	 */
	public static final int TAB_COLOR_INDEX = 0;

	/**
	 * The index of the gradient tab
	 */
	public static final int TAB_GRADIENT_INDEX = 1;

	/**
	 * The index of the picture tab
	 */
	public static final int TAB_IMAGE_INDEX = 2;

	/**
	 * The name of the PropertySheetPanel for modifying the gradient
	 */
	public static final String TABLE_NAME = "tabGradient";

	protected JdksColorChooser _colColor;
	protected JdksFileChooser _filImage;
	protected JdksGradientEditor _dksGradient;
	protected String _name;

	protected transient PropertySheetPanel _tabTexture;
	protected transient List<ChangeListener> _changeListeners;
	protected transient Change _changeListener;

	protected PanLayer() {
		_changeListeners = new LinkedList<ChangeListener>();
	}

	/**
	 * @param name the name of the tabPane
	 */
	public PanLayer(String name) {
		this();
		_name = name;
		_changeListener = new Change();
		super.addChangeListener(_changeListener);
		init();
	}

	protected final void init() {
		final JPanel panColor = new JPanel();
		panColor.setLayout(new GridBagLayout());
		panColor.add(getColColor());
		addTab(TAB_COLOR_TITLE, panColor);
		addTab(TAB_GRADIENT_TITLE, getDksGradient());
		final JPanel panImage = new JPanel();
		panImage.setLayout(new GridBagLayout());
		panImage.add(getFilImage());
		addTab(TAB_IMAGE_TITLE, panImage);
	}

	/**
	 * @return the gradient to use
	 */
	public JdksGradientEditor getDksGradient() {
		if (_dksGradient == null) {
			_dksGradient = new JdksGradientEditor();
			_dksGradient.setName(_name + DKS_GRADIENT_NAME);
			_dksGradient.addChangeListener(_changeListener);
		}
		return _dksGradient;
	}

	/**
	 * @see javax.swing.JTabbedPane#addChangeListener(javax.swing.event.ChangeListener)
	 * @param changeListener the ChangeListener to add
	 */
	public void addChangeListener(ChangeListener changeListener) {
		if (_changeListeners != null) {
			_changeListeners.add(changeListener);
		}
	}

	/**
	 * @see javax.swing.JTabbedPane#removeChangeListener(javax.swing.event.ChangeListener)
	 * @param changeListener the ChangeListener to remove
	 */
	public void removeChangeListener(ChangeListener changeListener) {
		_changeListeners.remove(changeListener);
	}

	/**
	 * @return the file chooser used to choose the file of the Picture
	 */
	public JdksFileChooser getFilImage() {
		if (_filImage == null) {
			_filImage = new JdksFileChooser(TAB_IMAGE_CAPTION, TAB_IMAGE_INFO);
			_filImage.setPreferredSize(new Dimension(250, 20));
			_filImage.setName(_name + TAB_IMAGE_NAME);
			_filImage.addChangeListener(_changeListener);
		}
		return _filImage;
	}

	/**
	 * @return the color chooser used to choose the color
	 */
	public JdksColorChooser getColColor() {
		if (_colColor == null) {
			_colColor = new JdksColorChooser(TAB_COLOR_CAPTION, TAB_COLOR_INFO);
			_colColor.setPreferredSize(new Dimension(250, 20));
			_colColor.setName(_name + TAB_COLOR_NAME);
			_colColor.addChangeListener(_changeListener);
		}
		return _colColor;
	}

	/**
	 * @return the PropertySheetPanel used for modifying the texture
	 */
	public PropertySheetPanel getTabTexture() {
		if (_tabTexture == null) {
			_tabTexture = new PropertySheetPanel();
			_tabTexture.setName(_name + TABLE_NAME);
		}
		return _tabTexture;
	}

	protected class Change implements ChangeListener {
		public void stateChanged(ChangeEvent e) {
			for (final ChangeListener change : _changeListeners) {
				change.stateChanged(e);
			}
		}
	}

	public String toString() {
		return "dks.src.textureEditor.PanLayer[name=" + _name + ",color=" + _colColor + ",image=" + _filImage + ",gradient=" + _dksGradient + "]";
	}

	protected Object readResolve() throws ObjectStreamException {
		_changeListeners = new LinkedList<ChangeListener>();
		_changeListener = new Change();
		return this;
	}
}