package dks.src.test.wordart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;

import junit.framework.TestCase;

import org.jdom.Element;
import org.jdom.JDOMException;

import dks.src.borderEditor.CBorder;
import dks.src.shadowEditor.CShadow;
import dks.src.textureEditor.CLayer;
import dks.src.textureEditor.CTexture;
import dks.src.warpEditor.CWarp;
import dks.src.wordart.CWordArt;

/**
 * @author   DKS
 */
public class TestCWordArt extends TestCase {

	private static final String ORIG_TEXT = "origText";
	private static final String TEST_TEXT = "testText";
	
	private static final Font ORIG_FONT = new Font("Arial", 16, Font.BOLD);
	private static final Font TEST_FONT = new Font("Verdana", 18, Font.ITALIC);
	
	private static final CTexture ORIG_TEXTURE = new CTexture(new CLayer(new Color(1, 2, 3, 4)), new CLayer(new Color(10, 20, 30, 40)), 2, 3, new BufferedImage(300, 251, BufferedImage.TYPE_3BYTE_BGR), new BufferedImage(301, 252, BufferedImage.TYPE_3BYTE_BGR));
	private static final CTexture TEST_TEXTURE = new CTexture(new CLayer(new Color(21, 22, 23, 24)), new CLayer(new Color(103, 203, 130, 140)), 6, 73, new BufferedImage(310, 211, BufferedImage.TYPE_3BYTE_BGR), new BufferedImage(321, 222, BufferedImage.TYPE_3BYTE_BGR));

	private static final CShadow ORIG_SHADOW = new CShadow(new BufferedImage(300, 400, BufferedImage.TYPE_4BYTE_ABGR), new Color(1, 2, 3, 4), 0.3f, 1, 2, 3);
	private static final CShadow TEST_SHADOW = new CShadow(new BufferedImage(301, 401, BufferedImage.TYPE_4BYTE_ABGR), new Color(11, 12, 13, 14), 0.4f, 11, 12, 13);
	
	private static final CWarp ORIG_WARP = new CWarp();
	private static final CWarp TEST_WARP = new CWarp();
	
	private static final CBorder TEST_BORDER = new CBorder(new Color(1, 2, 3, 4), 4);

	private static final Color ORIG_BACKGROUND_COLOR = new Color(190, 191, 192, 193);
	private static final Color TEST_BACKGROUND_COLOR = new Color(125, 126, 127, 128); 
	
	private static final Dimension ORIG_DIMENSION = new Dimension(1, 2);
	private static final Dimension TEST_DIMENSION = new Dimension(3, 4);
	
	private static final boolean ORIG_STRETCH = false;
	private static final boolean TEST_STRETCH = true;
	
	private static final boolean ORIG_AUTOSIZEFONT = false;
	private static final boolean TEST_AUTOSIZEFONT = true;
	
	public void testCWordArtStringFontCTextureCShadowCWarp() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
		assertEquals("Le constructeur n'a pas modifi la texture", wordArt.getTexture(), ORIG_TEXTURE);
		assertEquals("Le constructeur n'a pas modifi l'ombre", wordArt.getShadow(), ORIG_SHADOW);
		assertEquals("Le constructeur n'a pas modifie le warp", wordArt.getWarp(), ORIG_WARP);
	}

	public void testCWordArtStringFontCShadowCWarp() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_SHADOW, ORIG_WARP);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
		assertEquals("Le constructeur n'a pas modifi l'ombre", wordArt.getShadow(), ORIG_SHADOW);
		assertEquals("Le constructeur n'a pas modifie le warp", wordArt.getWarp(), ORIG_WARP);
	}

	public void testCWordArtStringFontCTextureCWarp() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_WARP);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
		assertEquals("Le constructeur n'a pas modifi la texture", wordArt.getTexture(), ORIG_TEXTURE);
		assertEquals("Le constructeur n'a pas modifie le warp", wordArt.getWarp(), ORIG_WARP);
	}

	public void testCWordArtStringFontCTextureCShadow() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
		assertEquals("Le constructeur n'a pas modifi la texture", wordArt.getTexture(), ORIG_TEXTURE);
		assertEquals("Le constructeur n'a pas modifi l'ombre", wordArt.getShadow(), ORIG_SHADOW);
	}

	public void testCWordArtStringFontCWarp() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
		assertEquals("Le constructeur n'a pas modifi la texture", wordArt.getTexture(), ORIG_TEXTURE);
		assertEquals("Le constructeur n'a pas modifie le warp", wordArt.getWarp(), ORIG_WARP);
	}

	public void testCWordArtStringFontCTexture() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
		assertEquals("Le constructeur n'a pas modifi la texture", wordArt.getTexture(), ORIG_TEXTURE);
	}

	public void testCWordArtStringFontCShadow() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
		assertEquals("Le constructeur n'a pas modifi l'ombre", wordArt.getShadow(), ORIG_SHADOW);
	}

	public void testCWordArtStringFont() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT);
		assertNotNull("Le constructeur n'a pas construit l'objet", wordArt);
		assertEquals("Le constructeur n'a pas modifi le texte", wordArt.getText(), ORIG_TEXT);
		assertEquals("Le constructeur n'a pas modifi la police", wordArt.getFont(), ORIG_FONT);
	}

	public void testSetShadow() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setShadow(TEST_SHADOW);
		assertEquals("La modification de l'ombre n'est pas effective", wordArt.getShadow(), TEST_SHADOW);
	}

	public void testSetText() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setText(TEST_TEXT);
		assertEquals("La modification du texte n'est pas effective", wordArt.getText(), TEST_TEXT);
	}

	public void testSetTexture() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setTexture(TEST_TEXTURE);
		assertEquals("La modification de la texture n'est pas effective", wordArt.getTexture(), TEST_TEXTURE);
	}

	public void testSetWarp() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setWarp(TEST_WARP);
		assertEquals("La modification du warp n'est pas effective", wordArt.getWarp(), TEST_WARP);
	}

	public void testSetFont() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setFont(TEST_FONT);
		assertEquals("La modification de la police n'est pas effective", wordArt.getFont(), TEST_FONT);
	}

	public void testSetBorder() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setBorder(TEST_BORDER);
		assertEquals("La modification de la bordure n'est pas effective", wordArt.getBorder(), TEST_BORDER);
	}

	public void testSetBackgroundColor() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setBackgroundColor(TEST_BACKGROUND_COLOR);
		assertEquals("La modification de la couleur de fond n'est pas effective", wordArt.getBackgroundColor(), TEST_BACKGROUND_COLOR);
	}

	public void testSetDimension() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setDimension(TEST_DIMENSION);
		assertEquals("La modification de la taille n'est pas effective", wordArt.getDimension(), TEST_DIMENSION);
	}
	
	public void testSetStretch() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setStretch(TEST_STRETCH);
		assertEquals("La modification du stretching n'est pas effective", wordArt.isStretch(), TEST_STRETCH);
	}
	
	public void testSetAutoSizeFont() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setAutoSizeFont(TEST_AUTOSIZEFONT);
		assertEquals("La modification de l'auto-dimension du texte n'est pas effective", wordArt.isAutoSizeFont(), TEST_AUTOSIZEFONT);
	}
	
	public void testXMLload() {
		CWordArt wordArt = new CWordArt(ORIG_TEXT, ORIG_FONT, ORIG_TEXTURE, ORIG_SHADOW, ORIG_WARP);
		wordArt.setBackgroundColor(ORIG_BACKGROUND_COLOR);
		wordArt.setDimension(ORIG_DIMENSION);
		wordArt.setStretch(ORIG_STRETCH);
		wordArt.setAutoSizeFont(ORIG_AUTOSIZEFONT);
		Element root = new Element("parent");
		wordArt.XMLsave(root);
		CWordArt test = new CWordArt(TEST_TEXT, TEST_FONT, TEST_TEXTURE, TEST_SHADOW, TEST_WARP);
		test.setBackgroundColor(TEST_BACKGROUND_COLOR);
		test.setDimension(TEST_DIMENSION);
		test.setStretch(TEST_STRETCH);
		test.setAutoSizeFont(TEST_AUTOSIZEFONT);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas modifi le texte", test.getText(), ORIG_TEXT);
		assertEquals("Le chargement par XML n'a pas modifi la police", test.getFont(), ORIG_FONT);
		assertEquals("Le chargement par XML n'a pas modifi la couleur de fond", test.getBackgroundColor(), ORIG_BACKGROUND_COLOR);
		assertEquals("Le chargement par XML n'a pas modifi la dimension", test.getDimension(), ORIG_DIMENSION);
		assertEquals("Le chargement par XML n'a pas modifi le stretching", test.isStretch(), ORIG_STRETCH);
		assertEquals("Le chargement par XML n'a modifi l'auto-dimension du texte", test.isAutoSizeFont(), ORIG_AUTOSIZEFONT);
	}
}
