package dks.src.test.warp;

import junit.framework.TestCase;

import org.jdom.Element;
import org.jdom.JDOMException;

import dks.src.utils.exception.NotEnoughElementException;
import dks.src.warpEditor.CWarp;

public class TestCWarp extends TestCase {
	
	private final static boolean TEST_ACTIVE = false; 
	
	public void testCWarp() {
		CWarp warp = new CWarp();
		assertNotNull("Le constructeur n'a pas cre l'objet", warp);
	}

	public void testAddVerticalLine() {
		CWarp warp = new CWarp();
		warp.addVerticalLine();
		assertEquals("L'ajout d'une colonne n'est pas effective", warp.getColNumber(), 3);
		warp.addVerticalLine();
		assertEquals("L'ajout d'une colonne n'est pas effective", warp.getColNumber(), 4);		
	}

	public void testRemoveVerticalLine() {
		CWarp warp = new CWarp();
		warp.addVerticalLine();
		warp.addVerticalLine();
		try {
			warp.removeVerticalLine();
		} catch (NotEnoughElementException e1) {
			e1.printStackTrace();
		}
		assertEquals("La suppression d'une colonne n'est pas effective", warp.getColNumber(), 3);
		try {
			warp.removeVerticalLine();
		} catch (NotEnoughElementException e1) {
			e1.printStackTrace();
		}
		assertEquals("La suppression d'une colonne n'est pas effective", warp.getColNumber(), 2);
		try {
			warp.removeVerticalLine();
			fail("L'exception NotEnoughElementException ne s'est pas dclenche");
		} catch (NotEnoughElementException e){
			assertEquals("La suppression d'une colonne n'est pas effective", warp.getColNumber(), 2);
		}
	}

	public void testAddHorizontalLine() {
		CWarp warp = new CWarp();
		warp.addHorizontalLine();
		assertEquals("L'ajout d'une ligne n'est pas effective", warp.getLineNumber(), 3);
		warp.addHorizontalLine();
		assertEquals("L'ajout d'une ligne n'est pas effective", warp.getLineNumber(), 4);		
	}

	public void testRemoveHorizontalLine() {
		CWarp warp = new CWarp();
		warp.addHorizontalLine();
		warp.addHorizontalLine();
		try {
			warp.removeHorizontalLine();
		} catch (NotEnoughElementException e1) {
			e1.printStackTrace();
		}
		assertEquals("La suppression d'une ligne n'est pas effective", warp.getLineNumber(), 3);
		try {
			warp.removeHorizontalLine();
		} catch (NotEnoughElementException e1) {
			e1.printStackTrace();
		}
		assertEquals("La suppression d'une ligne n'est pas effective", warp.getLineNumber(), 2);
		try {
			warp.removeHorizontalLine();
			fail("L'exception NotEnoughElementException ne s'est pas dclenche");
		} catch (NotEnoughElementException e){
			assertEquals("La suppression d'une ligne n'est pas effective", warp.getLineNumber(), 2);
		}
	}

	public void setActive() {
		CWarp warp = new CWarp();
		warp.setActive(TEST_ACTIVE);
		assertEquals("La modification de l'activit du warp n'est pas effective", warp.isActive(), TEST_ACTIVE);
	}
	
	public void testXMLload() {
		CWarp warp = new CWarp();
		warp.setActive(TEST_ACTIVE);
		warp.addVerticalLine();
		warp.addVerticalLine();
		warp.addVerticalLine();
		warp.addHorizontalLine();
		warp.addHorizontalLine();
		Element root = new Element("parent");
		warp.XMLsave(root);
		CWarp test = new CWarp();
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas charg les lignes", test.getLineNumber(), 4);
		assertEquals("Le chargement par XML n'a pas charg les colonnes", test.getColNumber(), 5);		
		assertEquals("Le chargement par XML n'a pas charg l'activit du warp", test.isActive(), TEST_ACTIVE);
	}
}
