package dks.src.test.borderEditor;

import java.awt.Color;

import com.l2fprod.common.propertysheet.Property;

import junit.framework.TestCase;
import dks.src.borderEditor.CBorder;
import dks.src.borderEditor.JdksBorderEditorPane;

/**
 * @author   DKS
 */
public class TestJBorderEditorPane extends TestCase {

	private static final CBorder ORIG_BORDER = new CBorder(new Color(1, 2, 3, 4), 1);
	private static final CBorder TEST_BORDER = new CBorder(new Color(2, 3, 4, 5), 2);
	
	public void testJBorderEditorPane() {
		JdksBorderEditorPane border = new JdksBorderEditorPane(ORIG_BORDER);
		assertNotNull("Le constructeur n'a pas construit l'objet", border);
		assertEquals("Le constructeur n'a pas initialiser la bordure", border.getBorderEditor(), ORIG_BORDER);
	}

	public void testSetBorderEditor() {
		JdksBorderEditorPane border = new JdksBorderEditorPane(ORIG_BORDER);
		border.setBorderEditor(TEST_BORDER);
		assertEquals("La modification de la bordure n'est pas effective", border.getBorderEditor(), TEST_BORDER);
	}

	public void testReloadBorder() {
		JdksBorderEditorPane border = new JdksBorderEditorPane(ORIG_BORDER);
		border.setBorderEditor(TEST_BORDER);
		Property[] properties = border.getProperties();
		assertEquals("La modification de la couleur de la proprit", properties[1].getValue(), ORIG_BORDER.getColor());
		assertEquals("La modification de la largeur de la proprit", properties[2].getValue(), ORIG_BORDER.getWidth());
	}
}
