package dks.src.test.borderEditor;

import java.awt.Color;

import org.jdom.Element;
import org.jdom.JDOMException;

import junit.framework.TestCase;
import dks.src.borderEditor.CBorder;

public class TestCBorder extends TestCase {

	private static final Color ORIG_COLOR = new Color(5, 6, 7, 8);
	private static final Color TEST_COLOR = new Color(1, 2, 3, 4);
	
	private static final int ORIG_WIDTH = 1;
	private static final int TEST_WIDTH = 2;
	
	private static final boolean TEST_VISIBLE = false;
	
	public void testCBorder() {
		CBorder border = new CBorder(ORIG_COLOR, ORIG_WIDTH);
		assertNotNull("Le constructeur n'a pas construit l'objet", border);
		assertEquals("Le constructeur n'a pas initialiser la couleur", border.getColor(), ORIG_COLOR);
		assertEquals("Le constructeur n'a pas initialiser la largeur", border.getWidth(), ORIG_WIDTH);
	}

	public void testSetColor() {
		CBorder border = new CBorder(ORIG_COLOR, ORIG_WIDTH);
		border.setColor(TEST_COLOR);
		assertEquals("La modification de la couleur n'est pas effective", border.getColor(), TEST_COLOR);
	}

	public void testSetWidth() {
		CBorder border = new CBorder(ORIG_COLOR, ORIG_WIDTH);
		border.setWidth(TEST_WIDTH);
		assertEquals("La modification de la largeur n'est pas effective", border.getWidth(), TEST_WIDTH);
	}

	public void testSetVisible() {
		CBorder border = new CBorder(ORIG_COLOR, ORIG_WIDTH);
		border.setVisible(TEST_VISIBLE);
		assertEquals("La modification de la visibilit de la bordure", border.isVisible(), TEST_VISIBLE);
	}
	
	public void testXMLload() {
		CBorder border = new CBorder(ORIG_COLOR, ORIG_WIDTH);
		border.setVisible(TEST_VISIBLE);
		Element root = new Element("parent");
		border.XMLsave(root);
		CBorder test = new CBorder(TEST_COLOR, TEST_WIDTH);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas modifi la couleur", test.getColor(), ORIG_COLOR);
		assertEquals("Le chargement par XML n'a pas modifi la largeur", test.getWidth(), ORIG_WIDTH);
		assertEquals("Le chargement par XML n'a pas modifi la visibilit", test.isVisible(), TEST_VISIBLE);
	}

}
