package dks.src.test;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

import javax.imageio.IIOParamController;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jdom.JDOMException;

import typecontrol.tools.CCommon;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;

import dks.src.borderEditor.JdksBorderEditorPane;
import dks.src.checkboardPanel.CheckboardPanel;
import dks.src.shadowEditor.CShadow;
import dks.src.shadowEditor.JdksShadowEditorPane;
import dks.src.textureEditor.CLayer;
import dks.src.textureEditor.CTexture;
import dks.src.textureEditor.ETypeLayer;
import dks.src.textureEditor.JdksTextureEditorPane;
import dks.src.textureEditor.PanLayer;
import dks.src.utils.exception.NotEnoughElementException;
import dks.src.utils.pictures.CPicture;
import dks.src.warpEditor.CPoint;
import dks.src.warpEditor.CWarp;
import dks.src.warpEditor.JdksWarpEditorPane;
import dks.src.wordart.CWordArt;
import dks.src.wordart.JdksWordArtEditorPane;

/**
 * @author   DKS
 */
public class FrmMain extends JFrame {

    private static final long serialVersionUID = 3245243956863874124L;

    /**
     * @author   DKS
     */
    protected enum EResize {
        RESIZE_NONE,
        RESIZE_TOP,
        RESIZE_LEFT,
        RESIZE_RIGHT,
        RESIZE_BOTTOM,
        RESIZE_TOP_LEFT,
        RESIZE_TOP_RIGHT,
        RESIZE_BOTTOM_LEFT,
        RESIZE_BOTTOM_RIGHT
    }

    protected enum EResizeType {
        RESIZE_TYPE_NONE,
        RESIZE_TYPE_TOTALSIZE,
        RESIZE_TYPE_DIMENSION
    }

    protected static final String ERROR_THEME_NOT_APPLYED_DESCRIPTION = "FrmUsers.FrmUsers : impossible d'appliquer le thme du systme";
    protected static final String TITLE = "test du dksWordArt";

    public static final String BTN_ADD_LINE_NAME = "btnAddLine";
    public static final String BTN_REMOVE_LINE_NAME = "btnRemoveLine";
    public static final String BTN_ADD_COLUMN_NAME = "btnAddColumn";
    public static final String BTN_REMOVE_COLUMN_NAME = "btnRemoveColumn";

    public static final String TAB_WORDART_NAME = "tabWordArt";

    public static final String PAN_WARP_EDITOR_NAME = "panWarpEditor";
    public static final String PAN_FOREGROUND_NAME = "panforeground";
    public static final String PAN_BACKGROUND_NAME = "panBackground";
    public static final String PAN_TEXTURE_NAME = "panTexture";

    public static final String TAB_TEXTURE_NAME = "tabTexture";
    public static final String TAB_MAIN_NAME = "panMain";
    public static final String TAB_SHADOW_NAME = "panShadow";
    public static final String TAB_BORDER_NAME = "panBorder";
    public static final String TAB_WARP_NAME = "panWarp";

    protected transient GUI _gui;
    protected transient PropertyChange _propertyChangeListener;
    protected transient Action _actionListener;
    protected transient Change _changeListener;
    protected transient Mouse _mouseListener;
    protected transient MouseMotion _mouseMotionListener;
    protected transient EResize _resize;
    protected transient EResizeType _resizeType;
    protected transient Dimension _mouseDimension;
    protected transient Point _totalSizePosition;
    protected transient boolean _lockUpdate;

    protected CWordArt _wordArt;
    protected Point _mouseClick;
    protected boolean _mouseDown;
    protected int _selectedLine;
    protected int _selectedColumn;
    protected Point _selectedPoint;

    public FrmMain() {
        super(TITLE);
        _lockUpdate = true;
        _resizeType = EResizeType.RESIZE_TYPE_NONE;
        boolean error = false;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException e) {
            error = true;
        } catch (InstantiationException e) {
            error = true;
        } catch (IllegalAccessException e) {
            error = true;
        } catch (UnsupportedLookAndFeelException e) {
            error = true;
        }
        if (error) {
            System.out.println(ERROR_THEME_NOT_APPLYED_DESCRIPTION);
        }
        SwingUtilities.updateComponentTreeUI(this);

        init();
        _lockUpdate = false;
        refresh();
    }

    protected void init() {
        _propertyChangeListener = new PropertyChange();
        _actionListener = new Action();
        _changeListener = new Change();
        _mouseListener = new Mouse();
        _mouseMotionListener = new MouseMotion();
        mnuFileNew_Click();
        _gui = new GUI();
        _wordArt.getBorder().setWidth(2);
        _wordArt.getBorder().setColor(Color.BLUE);
        _wordArt.getShadow().setVisible(false);
        _wordArt.getShadow().setSize(5);
        _wordArt.getShadow().setDistance(5);
        _wordArt.getShadow().setColor(new Color(0, 0, 0));
        _wordArt.getWarp().addHorizontalLine();
        _wordArt.getWarp().addHorizontalLine();
        _wordArt.getWarp().addVerticalLine();
        _wordArt.getWarp().addVerticalLine();
        refresh();
        reloadWordArt();
        pack();
        setVisible(true);
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        _totalSizePosition = new Point(0, 0);
    }

    public CWordArt getModel() {
        return _wordArt;
    }

    protected EResize getResizeType(int x, int y) {
        EResize result = EResize.RESIZE_NONE;
        if (_mouseDown) {
        	return _resize;
        }
        _resizeType = EResizeType.RESIZE_TYPE_NONE;
        if (_resizeType != EResizeType.RESIZE_TYPE_TOTALSIZE || !_mouseDown) {
	        if (x >= _gui.wordartX - 1 && x <= _gui.wordartX + GUI.DIMENSION_HANDLER_WIDTH + 1) {
	            if (y >= _gui.wordartY - 1 && y <= _gui.wordartY + GUI.DIMENSION_HANDLER_WIDTH + 1) {
	                result = EResize.RESIZE_TOP_LEFT;
	            } else if (y >= _gui.wordartY + _wordArt.getDimension().getHeight() - 1 && y <= _gui.wordartY + _wordArt.getDimension().getHeight() + GUI.DIMENSION_HANDLER_WIDTH + 1) {
	                result = EResize.RESIZE_BOTTOM_LEFT;
	            } else if (y >= _gui.wordartY - 1 && y <= _gui.wordartY + _wordArt.getDimension().getHeight() + 1) {
	                result = EResize.RESIZE_LEFT;
	            }
	        } else if (x >= (_gui.wordartX + (int) _wordArt.getDimension().getWidth() - GUI.DIMENSION_HANDLER_WIDTH - 1) && x <= _gui.wordartX + (int) _wordArt.getDimension().getWidth() + 1) {
	            if (y >= _gui.wordartY - 1 && y <= _gui.wordartY + GUI.DIMENSION_HANDLER_WIDTH + 1) {
	                result = EResize.RESIZE_TOP_RIGHT;
	            } else if (y >= _gui.wordartY + _wordArt.getDimension().getHeight() - 1 && y <= _gui.wordartY + _wordArt.getDimension().getHeight() + GUI.DIMENSION_HANDLER_WIDTH + 1) {
	                result = EResize.RESIZE_BOTTOM_RIGHT;
	            } else if (y >= _gui.wordartY - 1 && y <= _gui.wordartY + _wordArt.getDimension().getHeight() + 1) {
	                result = EResize.RESIZE_RIGHT;
	            }
	        } else if (x >= _gui.wordartX - 1 && x <= _gui.wordartX + (int) _wordArt.getDimension().getWidth() + 1) {
	            if (y >= _gui.wordartY && y <= _gui.wordartY + GUI.DIMENSION_HANDLER_WIDTH) {
	                result = EResize.RESIZE_TOP;
	            } else if (y >= _gui.wordartY + _wordArt.getDimension().getHeight() - 1 && y <= _gui.wordartY + _wordArt.getDimension().getHeight() + GUI.DIMENSION_HANDLER_WIDTH + 1) {
	                result = EResize.RESIZE_BOTTOM;
	            }
	        }
	        if (result != EResize.RESIZE_NONE) {
	        	//System.out.println("x = " + x + " ; y = " + y + " ; wordartX = " + _gui.wordartX + " ; wordartY = " + _gui.wordartY);
	            _resizeType = EResizeType.RESIZE_TYPE_DIMENSION;
	            return result;
	        }
        }
        if (x >= _totalSizePosition.x - 1 && x <= _totalSizePosition.x + GUI.DIMENSION_HANDLER_WIDTH + 1) {
            if (y >= _totalSizePosition.y - 1 && y <= _totalSizePosition.y + GUI.DIMENSION_HANDLER_WIDTH + 1) {
                result = EResize.RESIZE_TOP_LEFT;
            } else if (y >= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() - 1 && y <= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() + GUI.DIMENSION_HANDLER_WIDTH + 1) {
                result = EResize.RESIZE_BOTTOM_LEFT;
            } else if (y >= _totalSizePosition.y - 1 && y <= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() + 1) {
                result = EResize.RESIZE_LEFT;
            }
        } else if (x >= (_totalSizePosition.x + (int) _wordArt.getTotalSize().getWidth() - GUI.DIMENSION_HANDLER_WIDTH - 1) && x <= _totalSizePosition.x + (int) _wordArt.getTotalSize().getWidth() + 1) {
            if (y >= _totalSizePosition.y - 1 && y <= _totalSizePosition.y + GUI.DIMENSION_HANDLER_WIDTH + 1) {
                result = EResize.RESIZE_TOP_RIGHT;
            } else if (y >= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() - 1 && y <= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() + GUI.DIMENSION_HANDLER_WIDTH + 1) {
                result = EResize.RESIZE_BOTTOM_RIGHT;
            } else if (y >= _totalSizePosition.y - 1 && y <= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() + 1) {
                result = EResize.RESIZE_RIGHT;
            }
        } else if (x >= _totalSizePosition.x - 1 && x <= _totalSizePosition.x + (int) _wordArt.getTotalSize().getWidth() + 1) {
            if (y >= _totalSizePosition.y && y <= _totalSizePosition.y + GUI.DIMENSION_HANDLER_WIDTH) {
                result = EResize.RESIZE_TOP;
            } else if (y >= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() - 1 && y <= _totalSizePosition.y + _wordArt.getTotalSize().getHeight() + GUI.DIMENSION_HANDLER_WIDTH + 1) {
                result = EResize.RESIZE_BOTTOM;
            }
        }
        if (result != EResize.RESIZE_NONE) {
            _resizeType = EResizeType.RESIZE_TYPE_TOTALSIZE;
        }
        return result;
    }

    protected void reloadWordArt() {
        _gui.getTabWordArt().reloadModel();
        _gui.getPanBorder().reloadModel();
        _gui.getPanTexture().reloadModel();
        _gui.getEdtWarp().reloadModel();
        _gui.getPanShadow().reloadModel();
    }

    protected void tabTexture_Change(Property property) {
        reloadWordArt();
        refresh();
    }

    protected void btnAddColumn_Click() {
        _wordArt.getWarp().addVerticalLine();
        _gui.getEdtWarp().reloadModel();
        reloadWordArt();
        refresh();
    }

    protected void btnAddLine_Click() {
        _wordArt.getWarp().addHorizontalLine();
        _gui.getEdtWarp().reloadModel();
        reloadWordArt();
        refresh();
    }

    protected void btnRemoveColumn_Click() {
        try {
            _wordArt.getWarp().removeVerticalLine();
        } catch (NotEnoughElementException e) {
            e.printStackTrace();
        }
        _gui.getEdtWarp().reloadModel();
        reloadWordArt();
        refresh();
    }

    protected void btnRemoveLine_Click() {
        try {
            _wordArt.getWarp().removeHorizontalLine();
        } catch (NotEnoughElementException e) {
            e.printStackTrace();
        }
        _gui.getEdtWarp().reloadModel();
        reloadWordArt();
        refresh();
    }

    protected void refresh() {
        if (_gui != null && _gui.getPanApercu() != null) {
            _gui.getPanApercu().updateUI();
        }
    }

    protected void tabMain_Change() {
        refresh();
    }

    protected void mnuFileNew_Click() {
        _wordArt = new CWordArt("dksWordArt", new Font("Arial", Font.PLAIN, 108), new CTexture(new CLayer(Color.black), new CLayer(Color.black), 1, 1, null, null), new CShadow(), new CWarp());
        _wordArt.setDimension(new Dimension(345, 45));
        try {
            reloadWordArt();
            refresh();
        } catch (NullPointerException e) {}
    }

    protected void mnuFileExport_Click() {
        String[] formats = { "png", "gif", "jpeg" };
        String format = (String) JOptionPane.showInputDialog(this, "Slectionner un format d'exportation", "Slectionner un format", JOptionPane.INFORMATION_MESSAGE, null, formats, formats[0]);

        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType("image/" + format);
        ImageWriter writer = iterator.next();
        ImageWriteParam param = writer.getDefaultWriteParam();

        JFileChooser fileChooser = new JFileChooser();
        int result = fileChooser.showSaveDialog(this);
        if (result == JOptionPane.CANCEL_OPTION) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        String fileName = file.getPath();
        if (!fileName.endsWith(format)) {
            fileName += "." + format;
        }
        file = new File(fileName);
        if (file.exists()) {
            if (JOptionPane.showConfirmDialog(this, "Le fichier existe dj, voulez-vous l'craser ?", "Confirmation de la suppression", JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION) {
                return;
            }
        }
        try {
        	IIOParamController controller = param.getController();
        	if (controller != null) {
        		controller.activate(param);
        	}

            ImageOutputStream fios = ImageIO.createImageOutputStream(file);
            writer.setOutput(fios);
            int type = BufferedImage.TYPE_3BYTE_BGR;
            if (format.equals("png"))
            {
            	type = BufferedImage.TYPE_4BYTE_ABGR;
            }
            BufferedImage image = new BufferedImage(_wordArt.getTotalSize().width, _wordArt.getTotalSize().height, type);
            Graphics g = image.createGraphics();
            _wordArt.draw(g, 0, 0, true);
            g.dispose();
            writer.write(image);
            writer.dispose();
            fios.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    protected void mnuFileSave_Click() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showSaveDialog(this);
            if (result == JOptionPane.CANCEL_OPTION) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            String fileName = file.getPath();
            if (!fileName.endsWith(".xml")) {
                fileName += ".xml";
            }
            file = new File(fileName);
            _wordArt.XMLsave(file);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void mnuFileOpen_Click() {
        try {
            JFileChooser file = new JFileChooser();
            file.showOpenDialog(this);
            if (file.getSelectedFile() == null) {
                return;
            }
            _wordArt.XMLload(file.getSelectedFile());
            _gui.getPanBorder().reloadModel();
            JdksTextureEditorPane editor = _gui.getPanTexture();
            if (editor.getTextureEditor().getTextureFileName() == null) {
                editor.setTextureFile(null);
            } else {
                editor.setTextureFile(new File(editor.getTextureEditor().getTextureFileName()));
            }
            if (editor.getTextureEditor().getMaskFileName() == null) {
                editor.setMaskFile(null);
            } else {
                editor.setMaskFile(new File(editor.getTextureEditor().getMaskFileName()));
            }
            _gui.getPanTexture().reloadModel();
            _gui.getPanBackground().getFilImage().setValue(_wordArt.getTexture().getBackgroundLayer().getImageFileName());
            Integer index = 0;
            switch (_wordArt.getTexture().getBackgroundLayer().getType()) {
            case ColoredLayer:
                index = PanLayer.TAB_COLOR_INDEX;
                break;
            case GradientLayer:
                index = PanLayer.TAB_GRADIENT_INDEX;
                _gui.getPanBackground().getDksGradient().setGradient(_wordArt.getTexture().getBackgroundLayer().getGradient());
                break;
            case ImageLayer:
                index = PanLayer.TAB_IMAGE_INDEX;
                break;
            default:
                break;
            }
            _gui.getPanBackground().setSelectedIndex(index);
            _gui.getPanForeground().getFilImage().setValue(_wordArt.getTexture().getForegroundLayer().getImageFileName());
            switch (_wordArt.getTexture().getForegroundLayer().getType()) {
            case ColoredLayer:
                index = PanLayer.TAB_COLOR_INDEX;
                break;
            case GradientLayer:
                index = PanLayer.TAB_GRADIENT_INDEX;
                _gui.getPanForeground().getDksGradient().setGradient(_wordArt.getTexture().getForegroundLayer().getGradient());
                break;
            case ImageLayer:
                index = PanLayer.TAB_IMAGE_INDEX;
                break;
            default:
                break;
            }
            _gui.getPanForeground().setSelectedIndex(index);
            _gui.getPanShadow().reloadModel();
            refresh();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (JDOMException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Le fichier n'est pas un dksWordArt valide.", "Fichier invalide", JOptionPane.OK_OPTION + JOptionPane.WARNING_MESSAGE);
        }
    }

    protected Point getPointUnderPixel(int x, int y) {
        int width = _wordArt.getTotalSize().width - GUI.HANDLER_WIDTH;
        int height = _wordArt.getTotalSize().height - GUI.HANDLER_WIDTH;
        int colNumber = _wordArt.getWarp().getColNumber();
        int lineNumber = _wordArt.getWarp().getLineNumber();
        double horizontalStep = width / (colNumber - 1.0);
        double verticalStep = height / (lineNumber - 1.0);
        int line = -1;
        int column = -1;
        for (int i = 0; i < colNumber; i++) {
            int drawX = (int) (horizontalStep * i) + _totalSizePosition.x;
            for (int j = 0; j < lineNumber; j++) {
                int drawY = (int) (verticalStep * j + _totalSizePosition.y);
                int yPosition = drawY + _wordArt.getWarp().getPoint(i, j).getTransformationY();
                int xPosition = drawX + _wordArt.getWarp().getPoint(i, j).getTransformationX();
                if (y >= yPosition && y <= yPosition + GUI.HANDLER_WIDTH && x >= xPosition && x <= xPosition + GUI.HANDLER_WIDTH) {
                    line = i;
                    column = j;
                    break;
                }
            }
        }
        if (line > -1 && column > -1) {
            return new Point(column, line);
        }
        return null;
    }

    protected void panApercu_MouseDown(int x, int y) {
        if (!_mouseDown) {
            if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_WARP_INDEX) {
                Point point = getPointUnderPixel(x, y);
                if (point != null) {
                    _mouseClick = new Point(x, y);
                    _mouseDown = true;
                    _selectedLine = point.y;
                    _selectedColumn = point.x;
                    CPoint selectedPoint = _wordArt.getWarp().getPoint(_selectedLine, _selectedColumn);
                    _selectedPoint = new Point(selectedPoint.getTransformationX(), selectedPoint.getTransformationY());
                } else {
                    _mouseDown = false;
                }
            } else if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
                _resize = getResizeType(x, y);
                if (_resize != EResize.RESIZE_NONE) {
                    _mouseDown = true;
                    _mouseClick = new Point(x, y);
                    if (_resizeType == EResizeType.RESIZE_TYPE_TOTALSIZE) {
                    	_mouseDimension = (Dimension) _wordArt.getTotalSize().clone();
                    } else if (_resizeType == EResizeType.RESIZE_TYPE_DIMENSION) {
                    	_mouseDimension = (Dimension) _wordArt.getDimension().clone();
                    }
                } else {
                    _mouseDown = false;
                }
            }
        }
    }

    protected void panApercu_MouseMove(int x, int y) {
        if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
            EResize resizeType = getResizeType(x, y);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            switch (resizeType) {
            case RESIZE_LEFT:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_WIDTH_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_TOP:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_HEIGHT_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_BOTTOM:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_HEIGHT_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_RIGHT:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_WIDTH_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_TOP_LEFT:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_WIDTH_TOP_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_TOP_RIGHT:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_WIDTH_BOTTOM_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_BOTTOM_LEFT:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_WIDTH_BOTTOM_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_BOTTOM_RIGHT:
                _gui.getPanApercu().setCursor(toolkit.createCustomCursor(toolkit.getImage(getClass().getResource(GUI.CURSOR_PATH + GUI.CURSOR_RESIZE_WIDTH_TOP_FILENAME)), new Point(16, 16), "Curseur"));
                break;
            case RESIZE_NONE:
                _gui.getPanApercu().setCursor(null);
                break;
            }
        }
        if (_mouseDown) {
            if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_WARP_INDEX) {
                final int differenceX = x - _mouseClick.x;
                final int differenceY = y - _mouseClick.y;
                final CPoint point = _wordArt.getWarp().getPoint(_selectedLine, _selectedColumn);
                point.setTransformationX(_selectedPoint.x + differenceX);
                point.setTransformationY(_selectedPoint.y + differenceY);
                _gui.getPanApercu().updateUI();
            } else if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
                final int differenceX = (x - _mouseClick.x) * 2;
                final int differenceY = (y - _mouseClick.y) * 2;
                int height = (int) (_mouseDimension.getHeight());
                int width = (int) (_mouseDimension.getWidth());
                switch (_resize) {
                case RESIZE_TOP:
                case RESIZE_TOP_LEFT:
                case RESIZE_TOP_RIGHT:
                    height -= differenceY;
                    break;
                case RESIZE_BOTTOM:
                case RESIZE_BOTTOM_LEFT:
                case RESIZE_BOTTOM_RIGHT:
                    height += differenceY;
                    break;
                }
                switch (_resize) {
                case RESIZE_LEFT:
                case RESIZE_TOP_LEFT:
                case RESIZE_BOTTOM_LEFT:
                    width -= differenceX;
                    break;
                case RESIZE_RIGHT:
                case RESIZE_TOP_RIGHT:
                case RESIZE_BOTTOM_RIGHT:
                    width += differenceX;
                    break;
                }
                if (width <= 0) {
                    width = 1;
                }
                if (height <= 0) {
                    height = 1;
                }
                if (_resizeType == EResizeType.RESIZE_TYPE_TOTALSIZE) {
                    _wordArt.getTotalSize().setSize(width, height);
                } else if (_resizeType == EResizeType.RESIZE_TYPE_DIMENSION) {
                    _wordArt.getDimension().setSize(width, height);
                }
                _gui.getPanApercu().updateUI();
                _gui.getTabWordArt().reloadModel();
            }
        }
    }

    protected void panApercu_MouseUp() {
        _mouseDown = false;
        _resizeType = EResizeType.RESIZE_TYPE_NONE;
    }

    protected void panBackground_colColor_Change() {
        String color = ((PanLayer) _gui.getPanBackground()).getColColor().getValue();
        Color couleur = CCommon.getColorFromString(color);
        _wordArt.getTexture().getBackgroundLayer().setColor(couleur);
        refresh();
    }

    protected void panForeground_colColor_Change() {
        String color = ((PanLayer) _gui.getPanForeground()).getColColor().getValue();
        Color couleur = CCommon.getColorFromString(color);
        _wordArt.getTexture().getForegroundLayer().setColor(couleur);
        refresh();
    }

    protected void panBackground_filImage_Change() {
        try {
            BufferedImage image = ImageIO.read(new File(((PanLayer) _gui.getPanBackground()).getFilImage().getValue()));
            _wordArt.getTexture().getBackgroundLayer().setImage(image);
            _wordArt.getTexture().getBackgroundLayer().setImageFileName(((PanLayer) _gui.getPanBackground()).getFilImage().getValue());
        } catch (IOException e) {}
        refresh();
    }

    protected void panForeground_filImage_Change() {
        try {
            BufferedImage image = ImageIO.read(new File(((PanLayer) _gui.getPanForeground()).getFilImage().getValue()));
            _wordArt.getTexture().getForegroundLayer().setImage(image);
            _wordArt.getTexture().getForegroundLayer().setImageFileName(((PanLayer) _gui.getPanForeground()).getFilImage().getValue());
        } catch (IOException e) {}
        refresh();
    }

    protected void panBackground_dksGradient_Change() {
        _wordArt.getTexture().getBackgroundLayer().setGradient(((PanLayer) _gui.getPanBackground()).getDksGradient().getGradient());
        refresh();
    }

    protected void panForeground_dksGradient_Change() {
        _wordArt.getTexture().getForegroundLayer().setGradient(((PanLayer) _gui.getPanForeground()).getDksGradient().getGradient());
        refresh();
    }

    protected void panBackground_Select() {
        switch (_gui.getPanBackground().getSelectedIndex()) {
        case PanLayer.TAB_COLOR_INDEX:
            _wordArt.getTexture().getBackgroundLayer().setType(ETypeLayer.ColoredLayer);
            break;
        case PanLayer.TAB_GRADIENT_INDEX:
            _wordArt.getTexture().getBackgroundLayer().setGradient(((PanLayer) _gui.getPanBackground()).getDksGradient().getGradient());
            _wordArt.getTexture().getBackgroundLayer().setType(ETypeLayer.GradientLayer);
            break;
        case PanLayer.TAB_IMAGE_INDEX:
            _wordArt.getTexture().getBackgroundLayer().setType(ETypeLayer.ImageLayer);
            break;
        default:
            break;
        }
        refresh();
    }

    protected void panForeground_Select() {
        switch (_gui.getPanForeground().getSelectedIndex()) {
        case PanLayer.TAB_COLOR_INDEX:
            _wordArt.getTexture().getForegroundLayer().setType(ETypeLayer.ColoredLayer);
            break;
        case PanLayer.TAB_GRADIENT_INDEX:
            _wordArt.getTexture().getForegroundLayer().setGradient(((PanLayer) _gui.getPanForeground()).getDksGradient().getGradient());
            _wordArt.getTexture().getForegroundLayer().setType(ETypeLayer.GradientLayer);
            break;
        case PanLayer.TAB_IMAGE_INDEX:
            _wordArt.getTexture().getForegroundLayer().setType(ETypeLayer.ImageLayer);
            break;
        default:
            break;
        }
        refresh();
    }

    /**
     * @author   DKS
     */
    protected class GUI {

        protected static final String PAN_APERCU_NAME = "panApercu";

        private static final String BTN_ADD_LINE_CAPTION = "Ajouter une ligne";
        private static final String BTN_REMOVE_LINE_CAPTION = "Supprimer une ligne";
        private static final String BTN_ADD_COLUMN_CAPTION = "Ajouter une colonne";
        private static final String BTN_REMOVE_COLUMN_CAPTION = "Supprimer une colonne";

        protected static final int HANDLER_WIDTH = 5;
        protected static final int DIMENSION_LIMIT_WIDTH = 2;
        protected static final int DIMENSION_HANDLER_WIDTH = 5;
        protected static final String CURSOR_PATH = "/dks/src/res/";
        protected static final String CURSOR_RESIZE_WIDTH_FILENAME = "WestEast.png";
        protected static final String CURSOR_RESIZE_HEIGHT_FILENAME = "NorthSouth.png";
        protected static final String CURSOR_RESIZE_WIDTH_TOP_FILENAME = "NorthWest.png";
        protected static final String CURSOR_RESIZE_WIDTH_BOTTOM_FILENAME = "NorthEast.png";

        private static final String TAB_TEXT_TITLE = "WordArt";
        private static final String TAB_BORDER_TITLE = "Bordure";
        private static final String TAB_SHADOW_TITLE = "Ombre";
        private static final String TAB_WARP_TITLE = "Warp";

        protected static final int TAB_TEXT_INDEX = 0;
        protected static final int TAB_BORDER_INDEX = 1;
        protected static final int TAB_TEXTURE_INDEX = 2;
        protected static final int TAB_WARP_INDEX = 3;
        protected static final int TAB_SHADOW_INDEX = 4;

        private static final String TAB_BACKGROUND_TITLE = "Arrire plan de la texture";
        private static final String TAB_FOREGROUND_TITLE = "Premier plan de la texture";
        private static final String TAB_TEXTURE_TITLE = "Proprits de la texture";

        private static final String MNU_FILE_TITLE = "Fichier";
        private static final String MNU_FILE_NEW_TITLE = "Nouveau";
        private static final String MNU_FILE_NEW_NAME = "mnuFileNew";
        private static final String MNU_FILE_EXPORT_TITLE = "Exporter";
        private static final String MNU_FILE_EXPORT_NAME = "mnuFileExport";
        private static final String MNU_FILE_SAVE_TITLE = "Enregistrer";
        private static final String MNU_FILE_SAVE_NAME = "mnuFileSave";
        private static final String MNU_FILE_OPEN_TITLE = "Ouvrir";
        private static final String MNU_FILE_OPEN_NAME = "mnuFileOpen";

        private JSplitPane _splMain;
        private JPanel _panApercu;
        private JdksWordArtEditorPane _tabWordArt;
        private JTabbedPane _tabMain;
        private JdksBorderEditorPane _panBorder;
        private JdksShadowEditorPane _panShadow;
        private JdksWarpEditorPane _edtWarp;
        private JPanel _panWarp;
        private JButton _btnAddLine;
        private JButton _btnRemoveLine;
        private JButton _btnAddColumn;
        private JButton _btnRemoveColumn;
        private JdksTextureEditorPane _panTexture;
        private JTabbedPane _panTabs;
        private PanLayer _panBackground;
        private PanLayer _panForeground;
        private JMenuBar _mnuBarreMenu;
        private JMenu _mnuFile;
        private JMenuItem _mnuFileNew;
        private JMenuItem _mnuFileExport;
        private JMenuItem _mnuFileSave;
        private JMenuItem _mnuFileOpen;

        protected transient BufferedImage _image;

        protected int wordartX;
        protected int wordartY;

        public GUI() {
            this.init();
        }

        protected final void init() {
            setLayout(new BorderLayout());
            add(getMnuBarreMenu(), BorderLayout.NORTH);
            add(getSplMain(), BorderLayout.CENTER);
        }

        protected JPanel getPanApercu() {
            if (_panApercu == null) {
                _panApercu = new CheckboardPanel() {

                    private static final long serialVersionUID = 1L;

                    public void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        if (_lockUpdate) {
                            return;
                        }
                        _image = CPicture.resizeAndClearImage(_image, _wordArt.getTotalSize().width, _wordArt.getTotalSize().height);
                        if (_wordArt != null) {
                            Graphics2D copy = (Graphics2D) _image.getGraphics();
                            _wordArt.prepare(copy);
                            _totalSizePosition.x = (getWidth() - _wordArt.getTotalSize().width) / 2;
                            _totalSizePosition.y = (getHeight() - _wordArt.getTotalSize().height) / 2;
                            wordartX = (int) ((getWidth() - _wordArt.getDimension().getWidth()) / 2);
                            wordartY = (int) ((getHeight() - _wordArt.getDimension().getHeight()) / 2);
                            _wordArt.draw(copy, 0, 0);

                            g.drawImage(_image, _totalSizePosition.x, _totalSizePosition.y, null);

                            if (getTabMain().getSelectedIndex() == TAB_WARP_INDEX) {
                                if (_image != null) {
                                    int colNumber = _wordArt.getWarp().getColNumber();
                                    int lineNumber = _wordArt.getWarp().getLineNumber();
                                    double horizontalStep = (_wordArt.getTotalSize().width - HANDLER_WIDTH) / (colNumber - 1.0);
                                    double verticalStep = (_wordArt.getTotalSize().height - HANDLER_WIDTH) / (lineNumber - 1.0);
                                    for (int i = 0; i < colNumber; i++) {
                                        for (int j = 0; j < lineNumber; j++) {
                                            int drawY = (int) (verticalStep * j) + _totalSizePosition.y + _wordArt.getWarp().getPoint(i, j).getTransformationY();
                                            int drawX = (int) (horizontalStep * i) + _totalSizePosition.x + _wordArt.getWarp().getPoint(i, j).getTransformationX();
                                            g.setColor(Color.GREEN);
                                            g.fillRect(drawX, drawY, HANDLER_WIDTH, HANDLER_WIDTH);
                                        }
                                    }
                                }
                            }
                            if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
                                Graphics2D g2d = (Graphics2D) g;
                                Color oldColor = g2d.getColor();
                                Stroke oldStroke = g2d.getStroke();
                                g2d.setColor(new Color(255, 0, 0, 255));
                                g2d.setStroke(new BasicStroke(DIMENSION_LIMIT_WIDTH));
                                g2d.drawRect(wordartX, wordartY, _wordArt.getDimension().width, _wordArt.getDimension().height);

                                _totalSizePosition.x = (getWidth() - _wordArt.getTotalSize().width) / 2;
                                _totalSizePosition.y = (getHeight() - _wordArt.getTotalSize().height) / 2;
                                g2d.setColor(new Color(0, 0, 255, 255));
                                g2d.setStroke(new BasicStroke(DIMENSION_LIMIT_WIDTH));
                                g2d.drawRect(_totalSizePosition.x, _totalSizePosition.y, _wordArt.getTotalSize().width, _wordArt.getTotalSize().height);

                                g2d.setColor(oldColor);
                                g2d.setStroke(oldStroke);
                            }
                        }
                    }
                };
                _panApercu.setName(PAN_APERCU_NAME);
                _panApercu.addMouseListener(_mouseListener);
                _panApercu.addMouseMotionListener(_mouseMotionListener);
            }
            return _panApercu;
        }

        protected PanLayer getPanForeground() {
            if (_panForeground == null) {
                _panForeground = new PanLayer(FrmMain.PAN_FOREGROUND_NAME);
                _panForeground.setName(FrmMain.PAN_FOREGROUND_NAME);
                _panForeground.addChangeListener(_changeListener);
            }
            return _panForeground;
        }

        protected PanLayer getPanBackground() {
            if (_panBackground == null) {
                _panBackground = new PanLayer(FrmMain.PAN_BACKGROUND_NAME);
                _panBackground.setName(FrmMain.PAN_BACKGROUND_NAME);
                _panBackground.addChangeListener(_changeListener);
            }
            return _panBackground;
        }

        protected JTabbedPane getTabTexturePane() {
            if (_panTabs == null) {
                _panTabs = new JTabbedPane();
                _panTabs.setName(PAN_TEXTURE_NAME);
                _panTabs.addTab(TAB_BACKGROUND_TITLE, getPanBackground());
                _panTabs.addTab(TAB_FOREGROUND_TITLE, getPanForeground());
                _panTabs.addTab(TAB_TEXTURE_TITLE, getPanTexture());
            }
            return _panTabs;
        }

        protected JSplitPane getSplMain() {
            if (_splMain == null) {
                _splMain = new JSplitPane();
                _splMain.setOrientation(JSplitPane.VERTICAL_SPLIT);
                _splMain.add(getPanApercu(), JSplitPane.TOP);
                _splMain.add(getTabMain(), JSplitPane.BOTTOM);
                _splMain.setDividerLocation(200);
            }
            return _splMain;
        }

        protected JTabbedPane getTabMain() {
            if (_tabMain == null) {
                _tabMain = new JTabbedPane();
                _tabMain.setName(FrmMain.TAB_MAIN_NAME);
                _tabMain.addChangeListener(_changeListener);
                _tabMain.addTab(TAB_TEXT_TITLE, getTabWordArt());
                _tabMain.addTab(TAB_BORDER_TITLE, getPanBorder());
                _tabMain.addTab(TAB_TEXTURE_TITLE, getTabTexturePane());
                _tabMain.addTab(TAB_WARP_TITLE, getPanWarp());
                _tabMain.addTab(TAB_SHADOW_TITLE, getPanShadow());
            }
            return _tabMain;
        }

        protected JdksBorderEditorPane getPanBorder() {
            if (_panBorder == null) {
                _panBorder = new JdksBorderEditorPane(_wordArt.getBorder());
                _panBorder.addPropertyChangeListener(_propertyChangeListener);
                _panBorder.setName(FrmMain.TAB_BORDER_NAME);
            }
            return _panBorder;
        }

        protected JdksShadowEditorPane getPanShadow() {
            if (_panShadow == null) {
                _panShadow = new JdksShadowEditorPane(_wordArt.getShadow());
                _panShadow.addPropertyChangeListener(_propertyChangeListener);
                _panShadow.setName(FrmMain.TAB_SHADOW_NAME);
            }
            return _panShadow;
        }

        protected JdksTextureEditorPane getPanTexture() {
            if (_panTexture == null) {
                _panTexture = new JdksTextureEditorPane(_wordArt.getTexture());
                _panTexture.addPropertyChangeListener(_propertyChangeListener);
                _panTexture.setName(FrmMain.TAB_TEXTURE_NAME);
            }
            return _panTexture;
        }

        protected JdksWarpEditorPane getEdtWarp() {
            if (_edtWarp == null) {
                _edtWarp = new JdksWarpEditorPane(_wordArt.getWarp());
                _edtWarp.addPropertyChangeListener(_propertyChangeListener);
                _edtWarp.setName(PAN_WARP_EDITOR_NAME);
                _edtWarp.reloadModel();
            }
            return _edtWarp;
        }

        protected JPanel getPanWarp() {
            if (_panWarp == null) {
                _panWarp = new JPanel();
                _panWarp.setName(TAB_WARP_NAME);
                _panWarp.setLayout(new BorderLayout());
                JPanel panButtons = new JPanel();
                panButtons.setLayout(new GridLayout(2, 2));
                panButtons.add(getBtnAddColumn());
                panButtons.add(getBtnRemoveColumn());
                panButtons.add(getBtnAddLine());
                panButtons.add(getBtnRemoveLine());
                _panWarp.add(panButtons, BorderLayout.NORTH);
                _panWarp.add(getEdtWarp(), BorderLayout.CENTER);
            }
            return _panWarp;
        }

        protected JdksWordArtEditorPane getTabWordArt() {
            if (_tabWordArt == null) {
                _tabWordArt = new JdksWordArtEditorPane(_wordArt);
                _tabWordArt.setName(FrmMain.TAB_WORDART_NAME);
                _tabWordArt.addPropertySheetChangeListener(_propertyChangeListener);
            }
            return _tabWordArt;
        }

        protected JButton getBtnRemoveColumn() {
            if (_btnRemoveColumn == null) {
                _btnRemoveColumn = new JButton(BTN_REMOVE_COLUMN_CAPTION);
                _btnRemoveColumn.setName(BTN_REMOVE_COLUMN_NAME);
                _btnRemoveColumn.addActionListener(_actionListener);
            }
            return _btnRemoveColumn;
        }

        protected JButton getBtnAddColumn() {
            if (_btnAddColumn == null) {
                _btnAddColumn = new JButton(BTN_ADD_COLUMN_CAPTION);
                _btnAddColumn.setName(BTN_ADD_COLUMN_NAME);
                _btnAddColumn.addActionListener(_actionListener);
            }
            return _btnAddColumn;
        }

        protected JButton getBtnRemoveLine() {
            if (_btnRemoveLine == null) {
                _btnRemoveLine = new JButton(BTN_REMOVE_LINE_CAPTION);
                _btnRemoveLine.setName(BTN_REMOVE_LINE_NAME);
                _btnRemoveLine.addActionListener(_actionListener);
            }
            return _btnRemoveLine;
        }

        protected JButton getBtnAddLine() {
            if (_btnAddLine == null) {
                _btnAddLine = new JButton(BTN_ADD_LINE_CAPTION);
                _btnAddLine.setName(BTN_ADD_LINE_NAME);
                _btnAddLine.addActionListener(_actionListener);
            }
            return _btnAddLine;
        }

        protected JMenuItem getMnuFileExport() {
            if (_mnuFileExport == null) {
                _mnuFileExport = new JMenuItem(MNU_FILE_EXPORT_TITLE);
                _mnuFileExport.setName(MNU_FILE_EXPORT_NAME);
                _mnuFileExport.addActionListener(_actionListener);
            }
            return _mnuFileExport;
        }

        protected JMenu getMnuFile() {
            if (_mnuFile == null) {
                _mnuFile = new JMenu(MNU_FILE_TITLE);
                _mnuFile.add(getMnuFileNew());
                _mnuFile.addSeparator();
                _mnuFile.add(getMnuFileSave());
                _mnuFile.add(getmnuFileOpen());
                _mnuFile.addSeparator();
                _mnuFile.add(getMnuFileExport());
            }
            return _mnuFile;
        }

        protected JMenuItem getMnuFileNew() {
            if (_mnuFileNew == null) {
                _mnuFileNew = new JMenuItem(MNU_FILE_NEW_TITLE);
                _mnuFileNew.setName(MNU_FILE_NEW_NAME);
                _mnuFileNew.addActionListener(_actionListener);
            }
            return _mnuFileNew;
        }

        protected JMenuBar getMnuBarreMenu() {
            if (_mnuBarreMenu == null) {
                _mnuBarreMenu = new JMenuBar();
                _mnuBarreMenu.add(getMnuFile());
            }
            return _mnuBarreMenu;
        }

        protected JMenuItem getMnuFileSave() {
            if (_mnuFileSave == null) {
                _mnuFileSave = new JMenuItem(MNU_FILE_SAVE_TITLE);
                _mnuFileSave.setName(MNU_FILE_SAVE_NAME);
                _mnuFileSave.addActionListener(_actionListener);
            }
            return _mnuFileSave;
        }

        protected JMenuItem getmnuFileOpen() {
            if (_mnuFileOpen == null) {
                _mnuFileOpen = new JMenuItem(MNU_FILE_OPEN_TITLE);
                _mnuFileOpen.setName(MNU_FILE_OPEN_NAME);
                _mnuFileOpen.addActionListener(_actionListener);
            }
            return _mnuFileOpen;
        }
    }

    protected class Action implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            String name = ((JComponent) arg0.getSource()).getName();
            if (BTN_ADD_COLUMN_NAME.equals(name)) {
                btnAddColumn_Click();
            } else if (BTN_ADD_LINE_NAME.equals(name)) {
                btnAddLine_Click();
            } else if (BTN_REMOVE_COLUMN_NAME.equals(name)) {
                btnRemoveColumn_Click();
            } else if (BTN_REMOVE_LINE_NAME.equals(name)) {
                btnRemoveLine_Click();
            } else if (GUI.MNU_FILE_NEW_NAME.equals(name)) {
                mnuFileNew_Click();
            } else if (GUI.MNU_FILE_EXPORT_NAME.equals(name)) {
                mnuFileExport_Click();
            } else if (GUI.MNU_FILE_SAVE_NAME.equals(name)) {
                mnuFileSave_Click();
            } else if (GUI.MNU_FILE_OPEN_NAME.equals(name)) {
                mnuFileOpen_Click();
            }
        }
    }

    protected class PropertyChange implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getSource() instanceof PropertySheetPanel) {
                String name = ((JComponent) arg0.getSource()).getName();
                if (FrmMain.TAB_BORDER_NAME.equals(name)) {
                    refresh();
                } else if (FrmMain.TAB_SHADOW_NAME.equals(name)) {
                    refresh();
                }
            } else {
                tabTexture_Change((Property) arg0.getSource());
            }
        }
    }

    protected class Change implements ChangeListener {
        public void stateChanged(ChangeEvent arg0) {
            String name = ((JComponent) arg0.getSource()).getName();
            if (FrmMain.TAB_MAIN_NAME.equals(name)) {
                tabMain_Change();
            } else if (name.equals(FrmMain.PAN_BACKGROUND_NAME + PanLayer.TAB_COLOR_NAME)) {
                panBackground_colColor_Change();
            } else if (name.equals(FrmMain.PAN_FOREGROUND_NAME + PanLayer.TAB_COLOR_NAME)) {
                panForeground_colColor_Change();
            } else if (name.equals(FrmMain.PAN_BACKGROUND_NAME + PanLayer.TAB_IMAGE_NAME)) {
                panBackground_filImage_Change();
            } else if (name.equals(FrmMain.PAN_FOREGROUND_NAME + PanLayer.TAB_IMAGE_NAME)) {
                panForeground_filImage_Change();
            } else if (name.equals(FrmMain.PAN_BACKGROUND_NAME + PanLayer.DKS_GRADIENT_NAME)) {
                panBackground_dksGradient_Change();
            } else if (name.equals(FrmMain.PAN_FOREGROUND_NAME + PanLayer.DKS_GRADIENT_NAME)) {
                panForeground_dksGradient_Change();
            } else if (FrmMain.PAN_BACKGROUND_NAME.equals(name)) {
                panBackground_Select();
            } else if (FrmMain.PAN_FOREGROUND_NAME.equals(name)) {
                panForeground_Select();
            } else {
                refresh();
            }
        }
    }

    protected class Mouse implements MouseListener {

        public void mouseClicked(MouseEvent arg0) {}

        public void mouseEntered(MouseEvent arg0) {}

        public void mouseExited(MouseEvent arg0) {}

        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON1) {
                String name = ((JComponent) arg0.getSource()).getName();
                if (GUI.PAN_APERCU_NAME.equals(name)) {
                    if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_WARP_INDEX) {
                        panApercu_MouseDown(arg0.getX(), arg0.getY());
                    } else if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
                        panApercu_MouseDown(arg0.getX(), arg0.getY());
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON1) {
                String name = ((JComponent) arg0.getSource()).getName();
                if (GUI.PAN_APERCU_NAME.equals(name)) {
                    if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_WARP_INDEX) {
                        panApercu_MouseUp();
                    } else if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
                        panApercu_MouseUp();
                    }
                }
            }
        }

    }

    protected class MouseMotion implements MouseMotionListener {
        public void mouseDragged(MouseEvent arg0) {
            String name = ((JComponent) arg0.getSource()).getName();
            if (GUI.PAN_APERCU_NAME.equals(name)) {
                if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_WARP_INDEX) {
                    panApercu_MouseMove(arg0.getX(), arg0.getY());
                } else if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
                    panApercu_MouseMove(arg0.getX(), arg0.getY());
                }
            }
        }

        public void mouseMoved(MouseEvent arg0) {
            String name = ((JComponent) arg0.getSource()).getName();
            if (GUI.PAN_APERCU_NAME.equals(name)) {
                if (_gui.getTabMain().getSelectedIndex() == GUI.TAB_TEXT_INDEX) {
                    panApercu_MouseMove(arg0.getX(), arg0.getY());
                }
            }
        }

    }

    public static void main(String[] args) {
        new FrmMain();
    }

}
